/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ArrayMap
extends AbstractMap {
    private static final Object NULL = new Object();
    private static final int[] ALPHA = new int[]{1, 1, 3, 5, 9, 19, 39, 79, 159, 317, 633, 1265, 2531, 5063, 10125, 20251, 40503, 81007, 162013, 324027, 648055, 1296111, 2592223, 5184445, 10368889, 20737779, 41475559, 82951117, 165902235, 331804471, 663608943, 1327217885};
    private Object[] table;
    private int mask;
    private int alpha;
    private int size = 0;
    private int power;
    private int modCount;

    public ArrayMap() {
        this(16);
    }

    public ArrayMap(int n) {
        int n2 = 0;
        while (1 << n2 < n) {
            ++n2;
        }
        this.setPower(n2);
    }

    private void setPower(int n) {
        this.power = n;
        this.table = new Object[1 << this.power + 1];
        this.mask = this.table.length / 2 - 1;
        this.alpha = ALPHA[this.power];
    }

    private int firstBucket(int n) {
        return ((n & this.mask ^ n >> 32 - this.power) & this.mask) * 2;
    }

    private int nextBucket(int n) {
        return (n / 2 + this.alpha & this.mask) * 2;
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    private int getIndex(Object object) {
        if (object == null) {
            object = NULL;
        }
        int n = this.firstBucket(object.hashCode());
        Object object2 = this.table[n];
        while (object2 != null && !ArrayMap.eq(object, object2)) {
            n = this.nextBucket(n);
            object2 = this.table[n];
        }
        if (object2 == null) {
            return -1;
        }
        return n;
    }

    public Object get(Object object) {
        int n = this.getIndex(object);
        return n == -1 ? null : this.table[n + 1];
    }

    public boolean containsKey(Object object) {
        return this.getIndex(object) >= 0;
    }

    public Object getKey(Object object) {
        int n = this.getIndex(object);
        return n == -1 ? null : this.table[n];
    }

    public Object put(Object object, Object object2) {
        Object object3;
        if (object == null) {
            object = NULL;
        }
        if (this.size >= this.table.length / 2 * 3 / 4) {
            Object[] objectArray = this.table;
            this.setPower(this.power + 1);
            this.size = 0;
            for (int i = 0; i < objectArray.length; i += 2) {
                object3 = objectArray[i];
                if (object3 == null) continue;
                this.put(object3, objectArray[i + 1]);
            }
        }
        int n = this.firstBucket(object.hashCode());
        while (true) {
            Object object4;
            if ((object4 = this.table[n]) == null) {
                ++this.size;
                ++this.modCount;
                this.table[n] = object;
                this.table[n + 1] = object2;
                return null;
            }
            if (ArrayMap.eq(object4, object)) {
                object3 = this.table[n + 1];
                this.table[n + 1] = object2;
                return object3;
            }
            n = this.nextBucket(n);
        }
    }

    public Object remove(Object object) {
        if (object == null) {
            object = NULL;
        }
        int n = this.firstBucket(object.hashCode());
        Object object2 = this.table[n];
        while (object2 != null && !ArrayMap.eq(object, object2)) {
            n = this.nextBucket(n);
            object2 = this.table[n];
        }
        if (object2 == null) {
            return null;
        }
        Object object3 = this.table[n + 1];
        this.table[n] = null;
        this.table[n + 1] = null;
        --this.size;
        ++this.modCount;
        Object object4;
        while ((object4 = this.table[n = this.nextBucket(n)]) != null) {
            Object object5 = this.table[n + 1];
            this.table[n] = null;
            this.table[n + 1] = null;
            --this.size;
            this.put(object4, object5);
        }
        return object3;
    }

    public void clear() {
        Arrays.fill(this.table, null);
        this.size = 0;
        ++this.modCount;
    }

    public Set keySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new ArrayMapIterator(){

                    public Object next() {
                        if (this.expectedModCount != ArrayMap.this.modCount) {
                            throw new ConcurrentModificationException();
                        }
                        if (this.hasNext()) {
                            Object object = this.next;
                            this.next = null;
                            return object;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }

            public int size() {
                return ArrayMap.this.size();
            }

            public boolean contains(Object object) {
                return ArrayMap.this.containsKey(object);
            }
        };
    }

    public Collection values() {
        return new AbstractCollection(){

            public Iterator iterator() {
                return new ArrayMapIterator(){

                    public Object next() {
                        if (this.expectedModCount != ArrayMap.this.modCount) {
                            throw new ConcurrentModificationException();
                        }
                        if (this.hasNext()) {
                            this.next = null;
                            return ArrayMap.this.table[this.index + 1];
                        }
                        throw new NoSuchElementException();
                    }
                };
            }

            public int size() {
                return ArrayMap.this.size();
            }

            public boolean contains(Object object) {
                return ArrayMap.this.containsValue(object);
            }
        };
    }

    public Set entrySet() {
        return new AbstractSet(){

            public int size() {
                return ArrayMap.this.size();
            }

            public Iterator iterator() {
                return new ArrayMapIterator(){

                    public Object next() {
                        if (this.expectedModCount != ArrayMap.this.modCount) {
                            throw new ConcurrentModificationException();
                        }
                        if (this.hasNext()) {
                            Map.Entry entry = new Map.Entry(){
                                private final Object key;
                                private final Object value;
                                {
                                    this.key = next == NULL ? null : next;
                                    this.value = ArrayMap.this.table[index + 1];
                                }

                                public Object getKey() {
                                    return this.key;
                                }

                                public Object getValue() {
                                    return this.value;
                                }

                                public Object setValue(Object object) {
                                    throw new UnsupportedOperationException();
                                }

                                public boolean equals(Object object) {
                                    if (!(object instanceof Map.Entry)) {
                                        return false;
                                    }
                                    Map.Entry entry = (Map.Entry)object;
                                    if (this.key != null ? !this.key.equals(entry.getKey()) : entry.getKey() != null) {
                                        return false;
                                    }
                                    if (this.value != null) {
                                        return this.value.equals(entry.getValue());
                                    }
                                    return entry.getValue() == null;
                                }

                                public int hashCode() {
                                    return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
                                }
                            };
                            this.next = null;
                            return entry;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }
        };
    }

    private abstract class ArrayMapIterator
    implements Iterator {
        protected final int expectedModCount;
        protected int index;
        protected Object next;

        private ArrayMapIterator() {
            this.expectedModCount = ArrayMap.this.modCount;
            this.index = ArrayMap.this.table.length;
            this.next = null;
        }

        public final boolean hasNext() {
            while (this.next == null && this.index > 0) {
                this.index -= 2;
                this.next = ArrayMap.this.table[this.index];
            }
            return this.next != null;
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

