/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.Arrays;

public final class NumericArraySet {
    private static final int[] ALPHA = new int[]{1, 1, 3, 5, 9, 19, 39, 79, 159, 317, 633, 1265, 2531, 5063, 10125, 20251, 40503, 81007, 162013, 324027, 648055, 1296111, 2592223, 5184445, 10368889, 20737779, 41475559, 82951117, 165902235, 331804471, 663608943, 1327217885};
    private int[] table;
    private int mask;
    private int alpha;
    private int size = 0;
    private int power;
    private boolean zeroStored;

    public NumericArraySet() {
        this(32);
    }

    public NumericArraySet(int n) {
        int n2 = 0;
        while (1 << n2 < n) {
            ++n2;
        }
        this.setPower(n2);
    }

    private void setPower(int n) {
        this.power = n;
        this.table = new int[1 << this.power];
        this.mask = this.table.length - 1;
        this.alpha = ALPHA[this.power];
    }

    private int firstBucket(int n) {
        return (n & this.mask ^ n >> 32 - this.power) & this.mask;
    }

    private int nextBucket(int n) {
        return n + this.alpha & this.mask;
    }

    public void clear() {
        Arrays.fill(this.table, 0);
        this.zeroStored = false;
        this.size = 0;
    }

    public int size() {
        return this.size + (this.zeroStored ? 1 : 0);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean add(int n) {
        int n2;
        if (n == 0) {
            boolean bl = this.zeroStored;
            this.zeroStored = true;
            return !bl;
        }
        if (this.size >= this.table.length * 3 / 4) {
            int[] nArray = this.table;
            this.setPower(this.power + 1);
            this.size = 0;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                int n3 = nArray[n2];
                if (n3 == 0) continue;
                this.add(n3);
            }
        }
        int n4 = this.firstBucket(n);
        while (true) {
            if ((n2 = this.table[n4]) == 0) {
                ++this.size;
                this.table[n4] = n;
                return true;
            }
            if (n2 == n) {
                return false;
            }
            n4 = this.nextBucket(n4);
        }
    }

    public boolean contains(int n) {
        if (n == 0) {
            return this.zeroStored;
        }
        int n2 = this.firstBucket(n);
        int n3 = this.table[n2];
        while (n3 != 0 && n != n3) {
            n2 = this.nextBucket(n2);
            n3 = this.table[n2];
        }
        return n3 != 0;
    }

    public boolean remove(int n) {
        if (n == 0) {
            boolean bl = this.zeroStored;
            this.zeroStored = false;
            return bl;
        }
        int n2 = this.firstBucket(n);
        int n3 = this.table[n2];
        while (n3 != 0 && n != n3) {
            n2 = this.nextBucket(n2);
            n3 = this.table[n2];
        }
        if (n3 == 0) {
            return false;
        }
        this.table[n2] = 0;
        --this.size;
        int n4;
        while ((n4 = this.table[n2 = this.nextBucket(n2)]) != 0) {
            this.table[n2] = 0;
            --this.size;
            this.add(n4);
        }
        return true;
    }

    public String toString() {
        return "size=" + this.size() + " buckets=" + this.table.length;
    }
}

