/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.enumerations;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SequencingEnumerator
implements Enumeration {
    private static final int SIZE_UNIT = 5;
    private Enumeration[] enums;
    private int cur = 0;
    private int tail = 0;

    public SequencingEnumerator() {
        this.enums = new Enumeration[5];
    }

    public SequencingEnumerator(Enumeration[] enumerationArray) {
        this.enums = enumerationArray;
        this.tail = enumerationArray.length;
    }

    public synchronized void addEnumeration(Enumeration enumeration) {
        if (enumeration == null) {
            throw new NullPointerException("Null Enumeration passed in");
        }
        try {
            this.enums[this.tail] = enumeration;
            ++this.tail;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n = this.enums.length;
            Enumeration[] enumerationArray = new Enumeration[n + 5];
            System.arraycopy(this.enums, 0, enumerationArray, 0, n);
            enumerationArray[this.tail++] = enumeration;
            this.enums = enumerationArray;
        }
    }

    public boolean hasMoreElements() {
        if (this.cur >= this.tail) {
            return false;
        }
        return this.enums[this.cur].hasMoreElements() || ++this.cur < this.tail && this.hasMoreElements();
    }

    public Object nextElement() {
        try {
            return this.enums[this.cur].nextElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            if (++this.cur < this.tail) {
                return this.nextElement();
            }
            throw new NoSuchElementException();
        }
    }
}

