/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public final class ManifestManager {
    private static final boolean DEBUG = false;
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    private static final String SERVICES = "META-INF/services";
    private ArrayList manifests = this.getManifestEntries();

    public static Iterator getManifests() {
        return ManifestManagerMaker.MANAGER.manifests.iterator();
    }

    public static ArrayList getServices(Class clazz) {
        return ManifestManager.getProviderEntries(clazz);
    }

    private ManifestManager() {
    }

    private ArrayList getManifestEntries() {
        Enumeration<URL> enumeration;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        ArrayList<Manifest> arrayList = new ArrayList<Manifest>();
        try {
            enumeration = classLoader.getResources(MANIFEST);
        }
        catch (IOException iOException) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)iOException.getMessage()))).initCause(iOException);
        }
        while (enumeration.hasMoreElements()) {
            try {
                Object object;
                Comparable<File> comparable;
                Object object2;
                URL uRL = enumeration.nextElement();
                String string = uRL.toString();
                if (string.startsWith("jar:file:")) {
                    object2 = new URI(string.substring(4, string.indexOf(33)));
                    comparable = null;
                    comparable = ((URI)object2).getAuthority() != null ? new File(string.substring(9, string.indexOf(33))) : new File((URI)object2);
                    if (!((File)comparable).exists() || !((File)comparable).canRead() || !((File)comparable).isFile()) continue;
                    object = new JarFile((File)comparable, false, 1);
                    arrayList.add(((JarFile)object).getManifest());
                    ((ZipFile)object).close();
                    continue;
                }
                if (string.startsWith("zip:")) {
                    object2 = string = string.substring(4, string.indexOf(33));
                    if (!((String)object2).startsWith("/")) {
                        object2 = "/" + (String)object2;
                    }
                    if (!((File)(object = ((URI)(comparable = new URI((String)(object2 = "file:" + (String)object2)))).getAuthority() != null ? new File(string) : new File((URI)comparable))).exists() || !((File)object).canRead() || !((File)object).isFile()) continue;
                    JarFile jarFile = new JarFile((File)object, false, 1);
                    arrayList.add(jarFile.getManifest());
                    jarFile.close();
                    continue;
                }
                if (!string.startsWith("file:") || !((File)(comparable = ((URI)(object2 = new URI(string))).getAuthority() != null ? new File(string.substring(5)) : new File((URI)object2))).exists() || !((File)comparable).canRead() || !((File)comparable).isFile()) continue;
                object = new FileInputStream((File)comparable);
                arrayList.add(new Manifest((InputStream)object));
                ((FileInputStream)object).close();
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return arrayList;
    }

    private static ArrayList getProviderEntries(Class clazz) {
        Enumeration<URL> enumeration;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        ArrayList arrayList = new ArrayList();
        try {
            enumeration = classLoader.getResources("META-INF/services/" + clazz.getName());
        }
        catch (IOException iOException) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)iOException.getMessage()))).initCause(iOException);
        }
        while (enumeration.hasMoreElements()) {
            try {
                String string;
                URL uRL = enumeration.nextElement();
                InputStream inputStream = uRL.openStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                while ((string = bufferedReader.readLine()) != null) {
                    int n = string.indexOf(35);
                    if (n >= 0) {
                        string = string.substring(0, n);
                    }
                    if ((string = string.trim()).length() <= 0) continue;
                    try {
                        arrayList.add(classLoader.loadClass(string).newInstance());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InstantiationException instantiationException) {}
                }
                bufferedReader.close();
                ((Reader)inputStreamReader).close();
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return arrayList;
    }

    private static void p(String string) {
        System.out.println("<ManifestManager>: " + string);
    }

    private static final class ManifestManagerMaker {
        private static final ManifestManager MANAGER = new ManifestManager();

        private ManifestManagerMaker() {
        }
    }
}

