/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.string;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weblogic.utils.enumerations.ArrayEnumerator;

public class Sprintf {
    private static Hashtable cache = new Hashtable();
    private Integer width;
    private boolean widthStar = false;
    private Integer precision;
    private boolean precisionStar = false;
    private char conversion;
    private String string_value = null;
    private boolean leftJustified;
    private boolean showSign;
    private boolean extraSpace;
    private boolean altForm;
    private boolean zeroPadding;

    public static String sprintf(String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        Sprintf.sprintf(string, new Object[]{object}, stringBuffer);
        return stringBuffer.toString();
    }

    public static String sprintf(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        Sprintf.sprintf(string, objectArray, stringBuffer);
        return stringBuffer.toString();
    }

    public static String sprintf(String string, Enumeration enumeration) {
        StringBuffer stringBuffer = new StringBuffer();
        Sprintf.sprintf(string, enumeration, stringBuffer);
        return stringBuffer.toString();
    }

    public static void sprintf(String string, Object object, StringBuffer stringBuffer) {
        Sprintf.sprintf(string, new Object[]{object}, stringBuffer);
    }

    public static void sprintf(String string, Object[] objectArray, StringBuffer stringBuffer) {
        Sprintf.sprintf(string, new ArrayEnumerator(objectArray), stringBuffer);
    }

    public static void sprintf(String string, Enumeration enumeration, StringBuffer stringBuffer) {
        Sprintf[] sprintfArray = (Sprintf[])cache.get(string);
        if (sprintfArray == null) {
            sprintfArray = Sprintf.parseFormatString(string);
            cache.put(string, sprintfArray);
        }
        boolean bl = false;
        block12: for (int i = 0; i < sprintfArray.length; ++i) {
            Sprintf sprintf = sprintfArray[i];
            if (sprintf.string_value != null) {
                stringBuffer.append(sprintf.string_value);
                continue;
            }
            switch (sprintf.numStars()) {
                case 0: {
                    break;
                }
                case 1: {
                    sprintf.width = (Integer)enumeration.nextElement();
                    break;
                }
                case 2: {
                    sprintf.width = (Integer)enumeration.nextElement();
                    sprintf.precision = (Integer)enumeration.nextElement();
                }
            }
            switch (sprintf.conversion) {
                case 'd': 
                case 'i': {
                    sprintf.format_d(enumeration.nextElement(), stringBuffer);
                    continue block12;
                }
                case 's': {
                    sprintf.format_s(enumeration.nextElement(), stringBuffer);
                    continue block12;
                }
                case 'f': {
                    sprintf.format_f(enumeration.nextElement(), stringBuffer);
                    continue block12;
                }
                case 'x': {
                    sprintf.format_x(enumeration.nextElement(), stringBuffer, true);
                    continue block12;
                }
                case 'X': {
                    sprintf.format_x(enumeration.nextElement(), stringBuffer, false);
                    continue block12;
                }
            }
        }
    }

    private Sprintf(String string) {
        this.string_value = string;
    }

    private Sprintf(String string, String string2, char c) {
        this.conversion = c;
        this.leftJustified = string.indexOf(45) != -1;
        this.showSign = string.indexOf(43) != -1;
        this.extraSpace = string.indexOf(32) != -1 && !this.showSign;
        this.altForm = string.indexOf(35) != -1;
        boolean bl = this.zeroPadding = string.indexOf(48) != -1;
        if (string2.length() > 0) {
            String string3;
            String string4;
            int n = string2.indexOf(".");
            if (n == -1) {
                string4 = string2;
                string3 = null;
            } else if (n == 0) {
                string4 = null;
                string3 = string2;
            } else if (n == string2.length() - 1) {
                string4 = string2.substring(0, n);
                string3 = "0";
            } else {
                string4 = string2.substring(0, n);
                string3 = string2.substring(n + 1);
            }
            if (string4 != null) {
                if (string4.equals("*")) {
                    this.widthStar = true;
                } else {
                    this.width = new Integer(string4);
                }
            }
            if (string3 != null) {
                if (string3.equals("*")) {
                    this.precisionStar = true;
                } else {
                    this.precision = new Integer(string3);
                }
            }
        }
    }

    public int numStars() {
        int n = 0;
        if (this.widthStar) {
            ++n;
        }
        if (this.precisionStar) {
            ++n;
        }
        return n;
    }

    public static Sprintf[] parseFormatString(String string) {
        Vector<Sprintf> vector = new Vector<Sprintf>();
        int n = 0;
        String string2 = "";
        block9: while (n < string.length()) {
            char c = string.charAt(n++);
            switch (c) {
                case '%': {
                    String string3 = "";
                    String string4 = "";
                    block10: while (n < string.length()) {
                        char c2 = string.charAt(n++);
                        switch (c2) {
                            case '%': {
                                string2 = string2 + "" + c2;
                                continue block9;
                            }
                            case '0': {
                                if (string4.equals("")) {
                                    string3 = string3 + "" + c2;
                                    continue block10;
                                }
                                string4 = string4 + "" + c2;
                                continue block10;
                            }
                            case ' ': 
                            case '#': 
                            case '+': 
                            case '-': {
                                string3 = string3 + "" + c2;
                                continue block10;
                            }
                            case 'E': 
                            case 'G': 
                            case 'X': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': 
                            case 'g': 
                            case 'i': 
                            case 'o': 
                            case 's': 
                            case 'u': 
                            case 'x': {
                                if (!string2.equals("")) {
                                    vector.addElement(new Sprintf(string2));
                                    string2 = new String("");
                                }
                                vector.addElement(new Sprintf(string3, string4, c2));
                                continue block9;
                            }
                        }
                        string4 = string4 + "" + c2;
                    }
                    continue block9;
                }
            }
            string2 = string2 + "" + c;
        }
        if (!string2.equals("")) {
            vector.addElement(new Sprintf(string2));
        }
        Object[] objectArray = new Sprintf[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private final void format_d(Object object, StringBuffer stringBuffer) {
        block12: {
            int n;
            Number number = (Number)object;
            int n2 = stringBuffer.length();
            stringBuffer.append(number.toString());
            int n3 = Sprintf.getValue(this.width, 0);
            int n4 = Sprintf.getValue(this.precision, 1);
            int n5 = stringBuffer.length() - n2;
            int n6 = n4 - n5;
            if (n6 > 0) {
                for (n = 0; n < n6; ++n) {
                    stringBuffer.insert(n2, ' ');
                }
            }
            if (this.showSign) {
                n = number.intValue() >= 0 ? 43 : 45;
                stringBuffer.insert(n2, (char)n);
            } else if (this.extraSpace) {
                n = number.intValue() >= 0 ? 32 : 45;
                stringBuffer.insert(n2, (char)n);
            }
            n = Math.max(n3, n4);
            if (n <= stringBuffer.length() - n2) break block12;
            if (this.leftJustified) {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(' ');
                }
            } else {
                int n7 = n - (stringBuffer.length() - n2);
                if (this.zeroPadding && this.precision == null) {
                    int n8 = this.showSign || this.extraSpace ? n2 + 1 : n2;
                    for (int i = 0; i < n7; ++i) {
                        stringBuffer.insert(n8, '0');
                    }
                } else {
                    for (int i = 0; i < n7; ++i) {
                        stringBuffer.insert(n2, ' ');
                    }
                }
            }
        }
    }

    private final void format_s(Object object, StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        stringBuffer.append(object.toString());
        int n2 = Sprintf.getValue(this.precision, stringBuffer.length() - n);
        int n3 = Sprintf.getValue(this.width, 0);
        int n4 = n3 - n2;
        stringBuffer.setLength(n2 + n);
        if (this.leftJustified) {
            for (int i = 0; i < n4; ++i) {
                stringBuffer.append(' ');
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                stringBuffer.insert(n, ' ');
            }
        }
    }

    private final void format_f(Object object, StringBuffer stringBuffer) {
        block10: {
            int n;
            int n2 = stringBuffer.length();
            Number number = (Number)object;
            int n3 = Sprintf.getValue(this.precision, 6);
            int n4 = Sprintf.getValue(this.width, 0);
            stringBuffer.append(Sprintf.adjDoublePrecision(number, n3));
            int n5 = stringBuffer.length() - n2;
            int n6 = n3 - n5;
            if (this.showSign) {
                n = number.doubleValue() >= 0.0 ? 43 : 45;
                stringBuffer.insert(n2, (char)n);
            } else if (this.extraSpace) {
                n = number.doubleValue() >= 0.0 ? 32 : 45;
                stringBuffer.insert(n2, (char)n);
            }
            n = n4;
            if (n <= stringBuffer.length() - n2) break block10;
            if (this.leftJustified) {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(' ');
                }
            } else {
                int n7 = n - (stringBuffer.length() - n2);
                if (this.zeroPadding) {
                    int n8 = this.showSign || this.extraSpace ? n2 + 1 : n2;
                    for (int i = 0; i < n7; ++i) {
                        stringBuffer.insert(n8, '0');
                    }
                } else {
                    for (int i = 0; i < n7; ++i) {
                        stringBuffer.insert(n2, ' ');
                    }
                }
            }
        }
    }

    private final void format_x(Object object, StringBuffer stringBuffer, boolean bl) {
        block11: {
            int n;
            int n2 = stringBuffer.length();
            int n3 = (Integer)object;
            if (bl) {
                stringBuffer.append(Integer.toHexString(n3));
            } else {
                stringBuffer.append(Integer.toHexString(n3).toUpperCase());
            }
            int n4 = Sprintf.getValue(this.width, 0);
            int n5 = Sprintf.getValue(this.precision, 1);
            int n6 = stringBuffer.length() - n2;
            int n7 = n5 - n6;
            if (n7 > 0) {
                for (n = 0; n < n7; ++n) {
                    stringBuffer.insert(n2, '0');
                }
            }
            if ((n = Math.max(n4, n5)) <= stringBuffer.length() - n2) break block11;
            if (this.leftJustified) {
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(' ');
                }
            } else {
                int n8 = n - (stringBuffer.length() - n2);
                if (this.zeroPadding && this.precision == null) {
                    int n9 = this.showSign || this.extraSpace ? n2 + 1 : n2;
                    for (int i = 0; i < n8; ++i) {
                        stringBuffer.insert(n9, '0');
                    }
                } else {
                    for (int i = 0; i < n8; ++i) {
                        stringBuffer.insert(n2, ' ');
                    }
                }
            }
        }
    }

    private static int getValue(Integer n, int n2) {
        if (n == null) {
            return n2;
        }
        return n;
    }

    private static StringBuffer adjDoublePrecision(Number number, int n) {
        String string;
        String string2;
        String string3 = number.toString();
        int n2 = string3.indexOf(46);
        if (n2 == -1) {
            string2 = string3;
            string = "0";
        } else {
            string2 = string3.substring(0, n2);
            string = string3.substring(n2 + 1);
        }
        int n3 = string.length();
        if (n3 < n) {
            StringBuffer stringBuffer = new StringBuffer(string2 + "." + string);
            for (int i = n3; i < n; ++i) {
                stringBuffer.append('0');
            }
            return stringBuffer;
        }
        if (n3 > n) {
            double d = Double.valueOf(string2 + "." + string);
            d *= Math.pow(10.0, n);
            d = Math.rint(d);
            return Sprintf.adjDoublePrecision(new Double(d /= Math.pow(10.0, n)), n);
        }
        return new StringBuffer(string3);
    }
}

