/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.time;

public abstract class Timer {
    private long startTime;
    private long pausedTime;
    private long pausedElapsed;
    static /* synthetic */ Class class$weblogic$utils$time$JavaTimer;

    public void start() {
        if (this.startTime != 0L) {
            throw new IllegalStateException("Timer already started");
        }
        this.startTime = this.timestamp();
    }

    public void pause() {
        if (this.startTime == 0L) {
            throw new IllegalStateException("Timer not running");
        }
        this.pausedTime = this.timestamp();
    }

    public void resume() {
        if (this.pausedTime == 0L) {
            throw new IllegalStateException("Timer not paused");
        }
        this.pausedElapsed += this.timestamp() - this.pausedTime;
        this.pausedTime = 0L;
    }

    public long stop() {
        if (this.startTime == 0L) {
            throw new IllegalStateException("Timer not started");
        }
        long l = this.timestamp() - this.startTime - this.pausedElapsed;
        this.startTime = 0L;
        this.pausedElapsed = 0L;
        return l;
    }

    public static Timer createTimer() {
        try {
            return (Timer)TimerFactory.FACTORY.newInstance();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public abstract boolean isNative();

    public abstract long timestamp();

    public static void main(String[] stringArray) {
        Timer timer = Timer.createTimer();
        String string = timer.isNative() ? "Native" : "Java";
        System.err.println("Created " + string + " Timer: " + timer);
        timer.start();
        long l = System.currentTimeMillis();
        while (System.currentTimeMillis() - l < 1000L) {
        }
        long l2 = timer.stop();
        System.out.println("Timer ticks / sec: " + l2);
    }

    private static final class TimerFactory {
        private static final Class FACTORY = TimerFactory.getFactory();

        private TimerFactory() {
        }

        private static final Class getFactory() {
            try {
                Class.forName("java.lang.management.ThreadInfo");
                return Class.forName("weblogic.utils.time.JDK15NanoTimer");
            }
            catch (Exception exception) {
                return class$weblogic$utils$time$JavaTimer == null ? (class$weblogic$utils$time$JavaTimer = Timer.class$("weblogic.utils.time.JavaTimer")) : class$weblogic$utils$time$JavaTimer;
            }
        }
    }
}

