/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.zip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import weblogic.utils.zip.SafeZipFileInputStream;

class ZipURLConnection
extends URLConnection {
    private ZipFile zip;
    private ZipEntry ze;

    public ZipURLConnection(URL uRL) {
        super(uRL);
    }

    public String getContentType() {
        return ZipURLConnection.getFileNameMap().getContentTypeFor(this.url.getPath());
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new SafeZipFileInputStream(this.zip, this.ze);
    }

    public long getLastModified() {
        try {
            if (!this.connected) {
                this.connect();
            }
            return this.ze.getTime();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public void connect() throws IOException {
        String string = this.url.getFile();
        int n = string.indexOf("!/");
        if (n != -1) {
            File file;
            File file2;
            String string2 = this.url.getHost();
            String string3 = string.substring(0, n).replace('/', File.separatorChar);
            if (string2 != null && !string2.equals("")) {
                string3 = "" + File.separatorChar + File.separatorChar + string2 + string3;
            }
            if (!(file2 = new File(string3)).exists() && (file = new File(URLDecoder.decode(string3, "UTF-8"))).exists()) {
                file2 = file;
            }
            this.zip = new ZipFile(file2);
            this.ze = this.zip.getEntry(string.substring(n + 2, string.length()));
        }
        if (this.ze == null) {
            throw new FileNotFoundException(this.url.toString());
        }
        this.connected = true;
    }
}

