/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public final class CharUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private CharUtils() {
    }

    public static String unicodeEscapeInvalidChars(String string, String string2) {
        if (string2 == null) {
            string2 = System.getProperty("file.encoding");
        }
        if (string2 == null) {
            return CharUtils.unicodeEscapeNonASCIIChars(string);
        }
        Charset charset = Charset.forName(string2);
        if (charset == null) {
            return CharUtils.unicodeEscapeNonASCIIChars(string);
        }
        CharsetEncoder charsetEncoder = charset.newEncoder();
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (charsetEncoder.canEncode(c)) continue;
            i = CharUtils.escapeChar(stringBuffer, i);
        }
        return stringBuffer.toString();
    }

    private static String unicodeEscapeNonASCIIChars(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (c <= '\u007f') continue;
            i = CharUtils.escapeChar(stringBuffer, i);
        }
        return stringBuffer.toString();
    }

    private static int escapeChar(StringBuffer stringBuffer, int n) {
        char c = stringBuffer.charAt(n);
        stringBuffer.setCharAt(n++, '\\');
        char[] cArray = new char[]{'u', HEX_CHARS[c >> 12 & 0xF], HEX_CHARS[c >> 8 & 0xF], HEX_CHARS[c >> 4 & 0xF], HEX_CHARS[c & 0xF]};
        stringBuffer.insert(n, cArray);
        return n + 4;
    }
}

