/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import weblogic.utils.PlatformConstants;

public class ErrorCollectionException
extends Exception {
    static final long serialVersionUID = -8925276293755892689L;
    private static final String EOL = PlatformConstants.EOL;
    private final List errors = new ArrayList();

    public ErrorCollectionException() {
    }

    public ErrorCollectionException(String string) {
        super(string);
    }

    public ErrorCollectionException(Throwable throwable) {
        super(throwable);
        this.errors.add(throwable);
    }

    public ErrorCollectionException(String string, Throwable throwable) {
        super(string, throwable);
        this.errors.add(throwable);
    }

    public void addError(Throwable throwable) {
        this.errors.add(throwable);
    }

    public void add(Throwable throwable) {
        if (throwable instanceof ErrorCollectionException) {
            this.addCollection((ErrorCollectionException)throwable);
            return;
        }
        this.addError(throwable);
    }

    public void addCollection(ErrorCollectionException errorCollectionException) {
        assert (!this.containsNull(errorCollectionException));
        this.errors.addAll(errorCollectionException.getExceptions());
    }

    public int size() {
        return this.errors.size();
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    public Collection getExceptions() {
        return this.errors;
    }

    public Iterator getErrors() {
        return this.errors.iterator();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        if (this.errors == null || this.errors.isEmpty()) {
            super.printStackTrace(printStream);
            return;
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(printStream));
        this.printStackTrace(printWriter);
        printWriter.flush();
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (this.errors == null || this.errors.isEmpty()) {
            super.printStackTrace(printWriter);
            return;
        }
        printWriter.println("");
        printWriter.println("");
        printWriter.println("There are " + this.errors.size() + " nested errors:");
        printWriter.println("");
        String string = "";
        Iterator iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            printWriter.print(string);
            string = "and" + EOL + EOL;
            Throwable throwable = (Throwable)iterator.next();
            throwable.printStackTrace(printWriter);
            printWriter.println("");
        }
    }

    public String getBaseMessage() {
        return super.getMessage();
    }

    public String getMessage() {
        if (this.errors.isEmpty()) {
            return super.getMessage();
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private boolean containsNull(ErrorCollectionException errorCollectionException) {
        for (Object e : errorCollectionException.getExceptions()) {
            if (e != null) continue;
            return true;
        }
        return false;
    }
}

