/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Executable {
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = Logger.getLogger("weblogic.utils.Executable");
    private Process process;
    private OutputStream stdout = System.out;
    private OutputStream stderr = System.out;
    private InputStream stdin = null;
    private String path = System.getProperty("java.library.path");
    private String pathSeparator = System.getProperty("path.separator");
    private CharArrayWriter outwriter;
    private CharArrayWriter errwriter;
    private boolean useByteWriter = true;
    private boolean useByteReader = false;
    private boolean sendEndOfStreamChar = false;
    private static boolean isOpenVMS = false;

    public Executable() {
    }

    public Executable(OutputStream outputStream) {
        this.stdout = outputStream;
        this.stderr = outputStream;
    }

    public Executable(OutputStream outputStream, OutputStream outputStream2) {
        this.stdout = outputStream;
        this.stderr = outputStream2;
    }

    public final void setStdout(OutputStream outputStream) {
        this.stdout = outputStream;
    }

    public final void setStderr(OutputStream outputStream) {
        this.stderr = outputStream;
    }

    public final void setStdin(InputStream inputStream) {
        this.stdin = inputStream;
    }

    public final void setUseCharWriter(CharArrayWriter charArrayWriter, CharArrayWriter charArrayWriter2) {
        this.outwriter = charArrayWriter;
        this.errwriter = charArrayWriter2;
        this.useByteWriter = false;
    }

    public final void setUseByteReader() {
        this.useByteReader = true;
    }

    public final void setSendEndOfStreamChar() {
        this.sendEndOfStreamChar = true;
    }

    public final synchronized boolean exec(String[] stringArray) {
        return this.exec(stringArray, null);
    }

    public final synchronized boolean exec(String[] stringArray, String[] stringArray2) {
        return this.exec(stringArray, stringArray2, null);
    }

    public final synchronized boolean exec(String[] stringArray, String[] stringArray2, File file) {
        boolean bl;
        Object object;
        Object object2;
        try {
            if (isOpenVMS && stringArray[0].equals("javac")) {
                object2 = "vmsargs" + Double.toString(Math.random()).substring(2) + ".txt";
                object = new PrintWriter(new FileOutputStream("WEBLOGIC_BIN/" + (String)object2, false));
                for (int i = 1; i < stringArray.length; ++i) {
                    ((PrintWriter)object).println(stringArray[i]);
                }
                ((PrintWriter)object).close();
                String[] stringArray3 = new String[]{"WEBLOGIC_BIN:vms_javac.com", object2};
                this.process = Runtime.getRuntime().exec(stringArray3, stringArray2, file);
            } else {
                stringArray[0] = this.resolveExecutable(stringArray[0]);
                this.process = Runtime.getRuntime().exec(stringArray, stringArray2, file);
            }
        }
        catch (IOException iOException) {
            try {
                if (this.useByteWriter) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    iOException.printStackTrace(new PrintStream(byteArrayOutputStream));
                    this.stdout.write(byteArrayOutputStream.toByteArray());
                } else {
                    CharArrayWriter charArrayWriter = new CharArrayWriter();
                    iOException.printStackTrace(new PrintWriter(charArrayWriter));
                    this.outwriter.write(charArrayWriter.toString());
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return false;
        }
        if (this.stdin != null) {
            object2 = this.process.getOutputStream();
            try {
                int n;
                while ((n = this.stdin.read()) != -1) {
                    ((OutputStream)object2).write(n);
                }
                ((OutputStream)object2).flush();
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
            }
        }
        if (this.useByteWriter) {
            object2 = new Drainer(this.process.getInputStream(), this.stdout);
            object = new Drainer(this.process.getErrorStream(), this.stderr);
        } else {
            object2 = new Drainer(this.process.getInputStream(), this.outwriter);
            object = new Drainer(this.process.getErrorStream(), this.errwriter);
        }
        ((Thread)object2).start();
        ((Thread)object).start();
        try {
            this.process.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bl = this.process.waitFor() == 0;
            ((Thread)object2).join();
            ((Thread)object).join();
        }
        catch (InterruptedException interruptedException) {
            LOGGER.log(Level.WARNING, "", interruptedException);
            bl = false;
        }
        return bl;
    }

    public int getExitValue() throws InterruptedException {
        return this.process.exitValue();
    }

    public void setPath(String string) {
        this.path = string;
    }

    private String resolveExecutable(String string) {
        File file = new File(string);
        if (file.exists()) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.path, this.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file2 = new File(stringTokenizer.nextToken());
            file = new File(file2, string);
            if (file.exists() && file.isFile()) {
                return file.getAbsolutePath();
            }
            file = new File(file2, string + ".exe");
            if (!file.exists() || !file.isFile()) continue;
            return file.getAbsolutePath();
        }
        return string;
    }

    protected void handleIOException(IOException iOException) {
        iOException.printStackTrace();
    }

    static {
        if (0 == System.getProperty("os.name").compareTo("OpenVMS")) {
            isOpenVMS = true;
        }
    }

    private class Drainer
    extends Thread {
        private OutputStream out;
        private InputStream in;
        private CharArrayWriter writer;

        Drainer(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
        }

        Drainer(InputStream inputStream, CharArrayWriter charArrayWriter) {
            this.in = inputStream;
            this.writer = charArrayWriter;
        }

        public void run() {
            block18: {
                if (Executable.this.useByteWriter) {
                    DataInputStream dataInputStream = new DataInputStream(this.in);
                    PrintWriter printWriter = new PrintWriter(this.out);
                    try {
                        String string;
                        while ((string = dataInputStream.readLine()) != null) {
                            printWriter.println(string);
                            printWriter.flush();
                        }
                    }
                    catch (IOException iOException) {
                        Executable.this.handleIOException(iOException);
                    }
                } else {
                    InputStreamReader inputStreamReader = null;
                    DataInputStream dataInputStream = null;
                    if (!Executable.this.useByteReader) {
                        inputStreamReader = new InputStreamReader(this.in);
                    } else {
                        dataInputStream = new DataInputStream(this.in);
                    }
                    try {
                        int n;
                        if (inputStreamReader != null) {
                            int n2;
                            while ((n2 = inputStreamReader.read()) != -1 || Executable.this.sendEndOfStreamChar) {
                                this.writer.write(n2);
                                if (n2 != -1) continue;
                                break block18;
                            }
                            break block18;
                        }
                        while ((n = dataInputStream.read()) != -1) {
                            this.writer.write(n);
                        }
                    }
                    catch (Exception exception) {
                        try {
                            if (inputStreamReader != null) {
                                inputStreamReader.close();
                            } else {
                                dataInputStream.close();
                            }
                            this.writer.close();
                        }
                        catch (IOException iOException) {
                            Executable.this.handleIOException(iOException);
                        }
                    }
                }
            }
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

