/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.MissingResourceException;
import weblogic.utils.NestedThrowable;

public class InteropStackTraceUtils {
    private static String startBanner = "\nStart server side stack trace:\n";
    private static String endBanner = "End  server side stack trace\n";
    private static String marker = "\tat ";

    public static Throwable getThrowableWithStackTrace(Throwable throwable, boolean bl) {
        String string = throwable.getMessage();
        if (string == null || bl || string.indexOf(marker) == -1) {
            Class[] classArray;
            String string2 = InteropStackTraceUtils.throwable2StackTrace(throwable);
            String string3 = string == null ? startBanner + string2 + endBanner : string + "\n" + startBanner + string2 + endBanner;
            try {
                Field field = Throwable.class.getDeclaredField("detailMessage");
                field.setAccessible(true);
                field.set(throwable, string3);
                return throwable;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (throwable instanceof NestedThrowable) {
                classArray = new Class[]{String.class, Throwable.class};
                try {
                    Constructor<?> constructor = throwable.getClass().getConstructor(classArray);
                    Throwable throwable2 = ((NestedThrowable)((Object)throwable)).getNested();
                    Object[] objectArray = new Object[]{string3, throwable2};
                    return (Throwable)constructor.newInstance(objectArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            try {
                classArray = new Class[]{String.class};
                Constructor<?> constructor = throwable.getClass().getConstructor(classArray);
                Object[] objectArray = new Object[]{InteropStackTraceUtils.getComment(throwable, string3)};
                return (Throwable)constructor.newInstance(objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return throwable;
    }

    private static String getComment(Throwable throwable, String string) {
        Serializable serializable;
        if (throwable instanceof ExceptionInInitializerError && (throwable = ((ExceptionInInitializerError)(serializable = (ExceptionInInitializerError)throwable)).getException()) != null) {
            return InteropStackTraceUtils.getThrowableAsString(throwable, string);
        }
        if (throwable instanceof InvocationTargetException && (throwable = ((InvocationTargetException)(serializable = (InvocationTargetException)throwable)).getTargetException()) != null) {
            return InteropStackTraceUtils.getThrowableAsString(throwable, string);
        }
        if (throwable instanceof ParseException) {
            int n = ((ParseException)throwable).getErrorOffset();
            return string + "\nwith error offset = " + n;
        }
        if (throwable instanceof PropertyVetoException && (serializable = ((PropertyVetoException)throwable).getPropertyChangeEvent()) != null) {
            return string + "\nwith property change event = [" + serializable + "]";
        }
        if (throwable instanceof MissingResourceException) {
            serializable = (MissingResourceException)throwable;
            return string + "\nwith class name = [" + ((MissingResourceException)serializable).getClassName() + "]\nand with key = [" + ((MissingResourceException)serializable).getKey() + "]";
        }
        return string;
    }

    private static String getThrowableAsString(Throwable throwable, String string) {
        throwable = InteropStackTraceUtils.getThrowableWithStackTrace(throwable, false);
        return string + "\nwith nested Throwable:\n" + InteropStackTraceUtils.throwable2StackTrace(throwable) + "end nested Throwable\n";
    }

    public static String throwable2StackTrace(Throwable throwable) {
        if (throwable == null) {
            throwable = new Throwable("[Null exception passed, creating stack trace for offending caller]");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
        return byteArrayOutputStream.toString();
    }
}

