/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

import java.util.Iterator;
import java.util.Map;
import weblogic.utils.StackTraceUtilsClient;

public class StackTraceUtils
extends StackTraceUtilsClient {
    private static void dumpStack(Thread thread) {
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        if (stackTraceElementArray == null) {
            System.out.println("Stack on thread " + thread + " is corrupt, no stack trace");
        }
        System.out.println(thread + "\n");
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            System.out.println("\tat[" + i + "] " + stackTraceElement);
        }
    }

    public static void dumpStack() {
        StackTraceUtils.dumpStack(Thread.currentThread());
    }

    public static void dumpAllStacks() {
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Iterator<Thread> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            StackTraceUtils.dumpStack(iterator.next());
        }
    }
}

