/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ArrayIterator
implements Iterator {
    private final Object[] array;
    private final int maxIndex;
    private int index;

    public ArrayIterator(Object[] objectArray) {
        this(objectArray, 0, objectArray.length);
    }

    public ArrayIterator(Object[] objectArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n > objectArray.length) {
            throw new IllegalArgumentException();
        }
        if (n2 > objectArray.length - n) {
            throw new IllegalArgumentException();
        }
        this.array = objectArray;
        this.index = n;
        this.maxIndex = n2 + n;
    }

    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    public Object next() {
        if (this.index >= this.maxIndex) {
            throw new NoSuchElementException();
        }
        return this.array[this.index++];
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

