/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ArraySet
extends AbstractSet
implements Cloneable,
Serializable {
    private static final Object NULL = new Object();
    private static final int[] ALPHA = new int[]{1, 1, 3, 5, 9, 19, 39, 79, 159, 317, 633, 1265, 2531, 5063, 10125, 20251, 40503, 81007, 162013, 324027, 648055, 1296111, 2592223, 5184445, 10368889, 20737779, 41475559, 82951117, 165902235, 331804471, 663608943, 1327217885};
    private Object[] table;
    private int mask;
    private int alpha;
    private int size = 0;
    private int power;
    private int modCount;

    public Object clone() {
        ArraySet arraySet = new ArraySet();
        arraySet.table = (Object[])this.table.clone();
        arraySet.mask = this.mask;
        arraySet.alpha = this.alpha;
        arraySet.size = this.size;
        arraySet.power = this.power;
        arraySet.modCount = this.modCount;
        return arraySet;
    }

    public ArraySet() {
        this(32);
    }

    public ArraySet(int n) {
        int n2 = 0;
        while (1 << n2 < n) {
            ++n2;
        }
        this.setPower(n2);
    }

    private void setPower(int n) {
        this.power = n;
        this.table = new Object[1 << this.power];
        this.mask = this.table.length - 1;
        this.alpha = ALPHA[this.power];
    }

    private int firstBucket(int n) {
        return (n & this.mask ^ n >> 32 - this.power) & this.mask;
    }

    private int nextBucket(int n) {
        return n + this.alpha & this.mask;
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean add(Object object) {
        if (object == null) {
            object = NULL;
        }
        if (this.size >= this.table.length * 3 / 4) {
            Object[] objectArray = this.table;
            this.setPower(this.power + 1);
            this.size = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (object2 == null) continue;
                this.add(object2);
            }
        }
        int n = this.firstBucket(object.hashCode());
        while (true) {
            Object object3;
            if ((object3 = this.table[n]) == null) {
                ++this.size;
                ++this.modCount;
                this.table[n] = object;
                return true;
            }
            if (ArraySet.eq(object3, object)) {
                return false;
            }
            n = this.nextBucket(n);
        }
    }

    public Object get(Object object) {
        if (object == null) {
            object = NULL;
        }
        int n = this.firstBucket(object.hashCode());
        Object object2 = this.table[n];
        while (object2 != null && !ArraySet.eq(object, object2)) {
            n = this.nextBucket(n);
            object2 = this.table[n];
        }
        return object2;
    }

    public boolean contains(Object object) {
        return this.get(object) != null;
    }

    public boolean remove(Object object) {
        if (object == null) {
            object = NULL;
        }
        int n = this.firstBucket(object.hashCode());
        Object object2 = this.table[n];
        while (object2 != null && !ArraySet.eq(object, object2)) {
            n = this.nextBucket(n);
            object2 = this.table[n];
        }
        if (object2 == null) {
            return false;
        }
        this.table[n] = null;
        --this.size;
        ++this.modCount;
        Object object3;
        while ((object3 = this.table[n = this.nextBucket(n)]) != null) {
            this.table[n] = null;
            --this.size;
            this.add(object3);
        }
        return true;
    }

    public Iterator iterator() {
        return new Iterator(){
            private final int expectedModCount;
            private int index;
            private Object next;
            {
                this.expectedModCount = ArraySet.this.modCount;
                this.index = ArraySet.this.table.length;
                this.next = null;
            }

            public boolean hasNext() {
                while (this.next == null && this.index > 0) {
                    this.next = ArraySet.this.table[--this.index];
                }
                return this.next != null;
            }

            public Object next() {
                if (this.expectedModCount != ArraySet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.hasNext()) {
                    Object object = this.next;
                    this.next = null;
                    if (object == NULL) {
                        return null;
                    }
                    return object;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

