/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import weblogic.utils.collections.ArraySet;

public final class Iterators {
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private Iterators() {
    }

    public static boolean addAll(Collection collection, Iterator iterator) {
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= collection.add(iterator.next());
        }
        return bl;
    }

    public static boolean removeAll(Collection collection, Iterator iterator) {
        boolean bl = false;
        while (iterator.hasNext()) {
            bl |= collection.remove(iterator.next());
        }
        return bl;
    }

    public static boolean retainAll(Collection collection, Iterator iterator) {
        ArraySet arraySet = new ArraySet();
        Iterators.addAll(arraySet, iterator);
        return collection.retainAll(arraySet);
    }

    public static boolean containsAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static Object[] toArray(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        Iterators.addAll(arrayList, iterator);
        return arrayList.toArray();
    }

    public static Object[] toArray(Iterator iterator, Object[] objectArray) {
        ArrayList arrayList = new ArrayList();
        Iterators.addAll(arrayList, iterator);
        return arrayList.toArray(objectArray);
    }

    public static boolean equals(Iterator iterator, Iterator iterator2) {
        while (iterator.hasNext()) {
            Object e;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object e2 = iterator.next();
            if (e2.equals(e = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static boolean contains(Iterator iterator, Object object) {
        while (iterator.hasNext()) {
            if (!iterator.next().equals(object)) continue;
            return true;
        }
        return false;
    }
}

