/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.compiler;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import weblogic.utils.ArrayUtils;
import weblogic.utils.Classpath;
import weblogic.utils.Executable;
import weblogic.utils.FileUtils;
import weblogic.utils.Getopt2;
import weblogic.utils.PlatformConstants;
import weblogic.utils.StackTraceUtilsClient;
import weblogic.utils.compiler.ICompilerInvoker;
import weblogic.utils.io.ExtensionFilter;

public final class CompilerInvoker
implements ICompilerInvoker {
    private static final String[] STRING_ARRAY = new String[0];
    private static final Object[] NULL_ARGS = new Object[0];
    private static final Class[] NULL_ARG_TYPES = new Class[0];
    private static final Class[] COMPILE_ARG_TYPES = new Class[]{STRING_ARRAY.getClass(), PrintWriter.class};
    private static final String DEFAULT_COMPILER = "javac";
    private static final String DEFAULT_COMPILER_CLASS = "com.sun.tools.javac.Main";
    private static final String COMPILER_OPTS = "g,O,nowarn,nowrite,deprecation,J,classpath,source,d,normi,target";
    private String[] extraCompileFlags = STRING_ARRAY;
    private String compiler;
    private String classpath;
    private String compilerclass;
    private String targetDirectory;
    private boolean verbose;
    private boolean verboseJavac;
    private boolean noexit;
    private String rootDirectory;
    private String sourcepath;
    private int maxFiles;
    private final Getopt2 opts;
    private CharArrayWriter outwriter;
    private CharArrayWriter errwriter;
    private final Executable executable = new Executable();

    public CompilerInvoker() {
        this(new Getopt2());
    }

    public CompilerInvoker(Getopt2 getopt2) {
        this.opts = getopt2;
        this.initOpts();
    }

    private boolean verbose() {
        return this.verbose;
    }

    public void setExtraCompileFlags(String[] stringArray) {
        this.extraCompileFlags = stringArray;
    }

    public void setNoExit(boolean bl) {
        this.noexit = bl;
    }

    public void overrideTargetDirectory(String string) {
        this.targetDirectory = string;
    }

    public void setSourcepath(String string) {
        this.sourcepath = string;
    }

    public void setWantCompilerErrors(boolean bl) {
        if (bl) {
            this.outwriter = new CharArrayWriter();
            this.errwriter = new CharArrayWriter();
            this.executable.setUseCharWriter(this.outwriter, this.errwriter);
        }
    }

    public String getCompilerErrors() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.outwriter != null) {
            stringBuffer.append(this.outwriter.toString());
        }
        if (this.errwriter != null) {
            stringBuffer.append("\n");
            stringBuffer.append(this.errwriter.toString());
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    private static boolean quoted(String string) {
        if (string == null) {
            return false;
        }
        char[] cArray = new char[]{'\"', '\''};
        for (int i = 0; i < cArray.length; ++i) {
            if (string.charAt(0) != cArray[i] || string.charAt(string.length() - 1) != cArray[i]) continue;
            return true;
        }
        return false;
    }

    private void parseArguments() {
        this.compiler = this.opts.getOption("compiler");
        this.classpath = this.opts.getOption("classpath", Classpath.get());
        this.compilerclass = this.opts.getOption("compilerclass");
        this.noexit = this.opts.getBooleanOption("noexit", this.noexit);
        this.verbose = this.opts.getBooleanOption("commentary");
        this.verboseJavac = this.opts.getBooleanOption("verboseJavac");
        this.maxFiles = this.opts.getIntegerOption("maxfiles");
        if (CompilerInvoker.quoted(this.compiler)) {
            this.compiler = this.compiler.substring(1, this.compiler.length() - 1);
        }
        if (this.opts.hasOption("d")) {
            this.rootDirectory = this.opts.getOption("d");
            this.rootDirectory = this.rootDirectory.replace('/', File.separatorChar);
        }
    }

    private boolean execCompiler(List list, List list2) throws IOException {
        list.add(0, this.compiler);
        if (!list.contains("-classpath")) {
            String string = this.classpath;
            list.add("-classpath");
            list.add(string);
        }
        boolean bl = true;
        if (list2.size() == 1) {
            list.addAll(list2);
            String[] stringArray = list.toArray(new String[list.size()]);
            bl = this.executable.exec(stringArray);
        } else {
            int n;
            File file = new File(System.getProperty("java.io.tmpdir"));
            if (!file.exists()) {
                file.mkdirs();
            }
            int n2 = n = this.maxFiles > 0 ? this.maxFiles : list2.size();
            if (this.verbose) {
                System.err.println("Running with batch size " + n);
            }
            int n3 = 0;
            int n4 = list2.size();
            while (n3 < n4 && bl) {
                int n5 = Math.min(n3 + n, n4);
                if (this.verbose) {
                    System.err.println("Compiling files between " + n3 + ", " + n5);
                }
                bl = this.execCompilerBatch(list, list2, n3, n5);
                n3 = n5;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execCompilerBatch(List list, List list2, int n, int n2) throws IOException {
        File file = null;
        try {
            file = File.createTempFile("compileList", null);
            FileWriter fileWriter = new FileWriter(file);
            for (int i = n; i < n2; ++i) {
                String string = (String)list2.get(i);
                if (string.indexOf(32) != -1) {
                    string = new File(string).toURL().toString().substring(6);
                    string = "\"" + string + "\"";
                    list2.set(i, string);
                }
                fileWriter.write(string);
                fileWriter.write(PlatformConstants.EOL);
            }
            fileWriter.close();
            String[] stringArray = list.toArray(new String[1 + list.size()]);
            stringArray[list.size()] = "@" + file;
            boolean bl = this.executable.exec(stringArray);
            return bl;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    private boolean invokeCompile(Class clazz, List list, List list2) throws Throwable {
        int n;
        Object t;
        Method method;
        Constructor constructor;
        int n2 = clazz.getModifiers();
        if (!Modifier.isPublic(n2) || Modifier.isInterface(n2)) {
            throw new IllegalAccessException(clazz.getName() + " is not a public class");
        }
        try {
            constructor = clazz.getConstructor(NULL_ARG_TYPES);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodException(clazz.getName() + " does not define a " + "default constructor");
        }
        try {
            method = clazz.getMethod("compile", COMPILE_ARG_TYPES);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodException(clazz.getName() + " does not define " + "'public static int compile(String[], java.io.PrintWriter)'");
        }
        int n3 = method.getModifiers();
        if (!Modifier.isPublic(n3)) {
            throw new IllegalAccessException(clazz.getName() + ".compile(String[]" + "java.io.PrintWriter) must must be a public method");
        }
        PrintWriter printWriter = this.errwriter == null ? new PrintWriter(System.err, true) : new PrintWriter((Writer)this.errwriter, true);
        try {
            t = constructor.newInstance(NULL_ARGS);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        int n4 = n = this.maxFiles > 0 ? this.maxFiles : list2.size();
        if (this.verbose) {
            System.err.println("Running with batch size " + n);
        }
        boolean bl = true;
        int n5 = 0;
        int n6 = list2.size();
        while (n5 < n6 && bl) {
            int n7 = Math.min(n5 + n, n6);
            if (this.verbose) {
                System.err.println("Compiling files between " + n5 + ", " + n7);
            }
            ArrayList arrayList = new ArrayList(list.size() + (n7 - n5));
            arrayList.addAll(list);
            arrayList.addAll(list2.subList(n5, n7));
            Object[] objectArray = new Object[]{arrayList.toArray(new String[arrayList.size()]), printWriter};
            try {
                Number number = (Number)method.invoke(t, objectArray);
                bl = number.intValue() == 0;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getTargetException();
            }
            n5 = n7;
        }
        return bl;
    }

    public void compile() throws IOException {
        this.parseArguments();
        this.compile(this.opts.args());
    }

    public void compile(List list) throws IOException {
        this.parseArguments();
        this.compileMaybeExit(list);
    }

    public void compile(String[] stringArray) throws IOException {
        ArrayList arrayList = new ArrayList();
        ArrayUtils.addAll(arrayList, stringArray);
        this.compile(arrayList);
    }

    private List getArgs(boolean bl) {
        int n;
        String[] stringArray = this.opts.asCommandArray(COMPILER_OPTS);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.verboseJavac) {
            arrayList.add("-verbose");
        }
        if (this.sourcepath != null) {
            arrayList.add("-sourcepath");
            arrayList.add(this.sourcepath);
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-J")) {
                String string = stringArray[n] + stringArray[++n];
                if (!bl) {
                    arrayList.add(string);
                    continue;
                }
                System.out.println("[CompilerInvoker] Ignoring " + string + " as this is an inline compilation");
                continue;
            }
            if (stringArray[n].startsWith("-J")) {
                if (!bl) {
                    arrayList.add(stringArray[n]);
                    continue;
                }
                System.out.println("[CompilerInvoker] Ignoring the option '" + stringArray[n] + "' as this is an inline compilation");
                continue;
            }
            arrayList.add(stringArray[n]);
        }
        ArrayUtils.addAll(arrayList, this.extraCompileFlags);
        if (this.targetDirectory != null) {
            n = arrayList.indexOf("-d");
            if (n >= 0) {
                arrayList.set(n + 1, this.targetDirectory);
            } else {
                arrayList.add("-d");
                arrayList.add(this.targetDirectory);
            }
        }
        return arrayList;
    }

    private void compileMaybeExit(List list) throws IOException {
        boolean bl;
        Object object3;
        Object object2;
        if (this.compiler == null && this.compilerclass == null) {
            this.compilerclass = DEFAULT_COMPILER_CLASS;
        }
        if (this.compilerclass != null) {
            object2 = this.getArgs(true);
            if (this.verbose) {
                System.err.println("About to compile with arguments:");
                object3 = object2.iterator();
                while (object3.hasNext()) {
                    System.err.print(object3.next() + " ");
                }
                System.err.println();
            }
            try {
                object3 = Class.forName(this.compilerclass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Compiler class: '" + this.compilerclass + "', not found");
                throw new IOException("Compiler class: '" + this.compilerclass + "', not found " + classNotFoundException);
            }
            try {
                if (this.verbose) {
                    System.err.println("Compiling inline");
                }
                bl = this.invokeCompile((Class)object3, (List)object2, list);
            }
            catch (Throwable throwable) {
                throw new IOException("Compilation error " + StackTraceUtilsClient.throwable2StackTrace(throwable));
            }
        }
        object2 = this.getArgs(false);
        if (this.verbose) {
            System.err.println("About to compile with arguments:");
            object3 = object2.iterator();
            while (object3.hasNext()) {
                System.err.print(object3.next() + " ");
            }
            System.err.println();
        }
        if (this.verbose) {
            System.err.println("Exec'ing compiler");
        }
        bl = this.execCompiler((List)object2, list);
        if (bl) {
            if (!this.opts.hasOption("keepgenerated")) {
                for (Object object3 : list) {
                    File file;
                    if (((String)object3).endsWith("*.java")) {
                        file = new File(((String)object3).substring(0, ((String)object3).indexOf("*.java")));
                        FileUtils.remove(file, new ExtensionFilter("java"));
                        continue;
                    }
                    if (((String)object3).endsWith("*Stub.java")) {
                        file = new File(((String)object3).substring(0, ((String)object3).indexOf("*Stub.java")));
                        FileUtils.remove(file, new FileFilter(){

                            public boolean accept(File file) {
                                return file.getName().endsWith("Stub.java");
                            }
                        });
                        continue;
                    }
                    if (((String)object3).endsWith("*Skel.java")) {
                        file = new File(((String)object3).substring(0, ((String)object3).indexOf("*Skel.java")));
                        FileUtils.remove(file, new FileFilter(){

                            public boolean accept(File file) {
                                return file.getName().endsWith("Skel.java");
                            }
                        });
                        continue;
                    }
                    file = new File((String)object3);
                    if (!file.exists()) continue;
                    if (this.verbose()) {
                        System.out.println("Deleting: '" + file.getAbsolutePath() + "'");
                    }
                    file.delete();
                }
            }
        } else {
            if (this.noexit) {
                throw new IOException("Compiler failed executable.exec: " + this.getCompilerErrors());
            }
            System.out.println("Exec failed .. exiting");
            System.exit(1);
        }
    }

    private void initOpts() {
        Getopt2 getopt2 = CompilerInvoker.getJopts();
        this.opts.addFlag("keepgenerated", "Keep the generated .java files.");
        this.opts.addFlag("noexit", "Throw an exception on failure rather than calling System.exit()");
        this.opts.addFlag("commentary", "Emit commentary.");
        this.opts.addOption("compiler", DEFAULT_COMPILER, "Java compiler to exec.  If not specified, the -compilerclass option will be used.");
        this.opts.addOption("compilerclass", DEFAULT_COMPILER_CLASS, "Compiler class to invoke.");
        this.opts.addFlag("g", "Compile debugging info into class file.");
        this.opts.addFlag("O", "Compile with optimization on.");
        this.opts.addFlag("nowarn", "Compile without warnings.");
        this.opts.addFlag("verbose", "Compile with verbose output.");
        this.opts.addFlag("verboseJavac", "Enable Java compiler verbose output.");
        this.opts.addFlag("nowrite", "Don't generate .class files.");
        this.opts.addFlag("deprecation", "Warn about deprecated calls.");
        this.opts.addFlag("normi", "Passed through to Symantec's sj.");
        this.opts.addOption("classpath", "path", "Classpath to use.");
        this.opts.addOption("source", "source", "Source version.");
        this.opts.addOption("target", "target", "Target version.");
        this.opts.addOption("d", "dir", "Target (top-level) directory.");
        this.opts.addSubOpt("J", getopt2, "Flags passed through to java runtime.");
    }

    private static Getopt2 getJopts() {
        Getopt2 getopt2 = new Getopt2();
        getopt2.addFlag("help", "print out this message");
        getopt2.addFlag("version", "print out the build version");
        getopt2.addFlag("verbose", "turn on verbose mode");
        getopt2.addAlias("v", "verbose");
        getopt2.addFlag("debug", "enable remote JAVA debugging");
        getopt2.addFlag("noasyncgc", "don't allow asynchronous garbage collection");
        getopt2.addFlag("verbosegc", "print a message when garbage collection occurs");
        getopt2.addFlag("noclassgc", "disable class garbage collection");
        getopt2.addArgFlag("ss", "number", "set the maximum native stack size for any thread");
        getopt2.addArgFlag("oss", "number", "set the maximum Java stack size for any thread");
        getopt2.addArgFlag("ms", "number", "set the initial Java heap size");
        getopt2.addArgFlag("mx", "number", "set the maximum Java heap size");
        getopt2.addArgFlag("Xss", "number", "set the maximum native stack size for any thread");
        getopt2.addArgFlag("Xoss", "number", "set the maximum Java stack size for any thread");
        getopt2.addArgFlag("Xms", "number", "set the initial Java heap size");
        getopt2.addArgFlag("Xmx", "number", "set the maximum Java heap size");
        getopt2.addArgFlag("XX:MaxPermSize=", "number", "set the maximum Perm Size");
        getopt2.addOption("classpath", "directories separated by semicolons", "list directories in which to look for classes");
        getopt2.addOption("source", "source version", "source version");
        getopt2.addOption("target", "target version", "target version");
        getopt2.addArgFlag("prof", "file", "output profiling data to .\\java.prof or .\\<file>");
        getopt2.addFlag("verify", "verify all classes when read in");
        getopt2.addFlag("verifyremote", "verify classes read in over the network [default]");
        getopt2.addFlag("noverify", "do not verify any class");
        getopt2.addFlag("nojit", "disable JIT compiler");
        return getopt2;
    }

    public static void main(String[] stringArray) throws IOException {
        CompilerInvoker compilerInvoker = new CompilerInvoker();
        compilerInvoker.compile(stringArray);
    }
}

