/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.encoders;

public class Base64Bytes {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    static final int LINE_SEPARATOR_LEN = LINE_SEPARATOR.length();
    static final int SUN_MISC_LINE_LENGTH = 76;
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char[] intToAltBase64 = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', ',', '-', '.', ':', ';', '<', '>', '@', '[', ']', '^', '`', '_', '{', '|', '}', '~', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '?'};
    private static final byte[] base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final byte[] altBase64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, -1, 62, 9, 10, 11, -1, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 12, 13, 14, -1, 15, 63, 16, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 17, -1, 18, 19, 21, 20, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 22, 23, 24, 25};

    Base64Bytes() {
    }

    public static String byteArrayToBase64(byte[] byArray, boolean bl) {
        return Base64Bytes.byteArrayToBase64(byArray, false, bl);
    }

    public static String byteArrayToAltBase64(byte[] byArray, boolean bl) {
        return Base64Bytes.byteArrayToBase64(byArray, true, bl);
    }

    private static String byteArrayToBase64(byte[] byArray, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3 = byArray.length;
        int n4 = n3 / 3;
        int n5 = n3 - 3 * n4;
        int n6 = 4 * ((n3 + 2) / 3);
        if (bl2) {
            int n7 = n6 / 76 + 1;
            n6 += n7 * LINE_SEPARATOR_LEN;
        }
        StringBuilder stringBuilder = new StringBuilder(n6);
        char[] cArray = bl ? intToAltBase64 : intToBase64;
        int n8 = 0;
        int n9 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            n = byArray[n8++] & 0xFF;
            int n10 = byArray[n8++] & 0xFF;
            int n11 = byArray[n8++] & 0xFF;
            stringBuilder.append(cArray[n >> 2]);
            stringBuilder.append(cArray[n << 4 & 0x3F | n10 >> 4]);
            stringBuilder.append(cArray[n10 << 2 & 0x3F | n11 >> 6]);
            stringBuilder.append(cArray[n11 & 0x3F]);
            if (!bl2 || (n9 += 4) != 76) continue;
            stringBuilder.append(LINE_SEPARATOR);
            n9 = 0;
        }
        if (n5 != 0) {
            n2 = byArray[n8++] & 0xFF;
            stringBuilder.append(cArray[n2 >> 2]);
            if (n5 == 1) {
                stringBuilder.append(cArray[n2 << 4 & 0x3F]);
                stringBuilder.append("==");
            } else {
                n = byArray[n8++] & 0xFF;
                stringBuilder.append(cArray[n2 << 4 & 0x3F | n >> 4]);
                stringBuilder.append(cArray[n << 2 & 0x3F]);
                stringBuilder.append('=');
            }
            if (bl2) {
                stringBuilder.append(LINE_SEPARATOR);
            }
        } else if (bl2 && n9 != 0) {
            stringBuilder.append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public static byte[] base64ToByteArray(String string, boolean bl) {
        return Base64Bytes.base64ToByteArray(string, false, bl);
    }

    public static byte[] altBase64ToByteArray(String string, boolean bl) {
        return Base64Bytes.base64ToByteArray(string, true, bl);
    }

    private static byte[] base64ToByteArray(String string, boolean bl, boolean bl2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        byte[] byArray = bl ? altBase64ToInt : base64ToInt;
        int n6 = string.length();
        int n7 = 0;
        int n8 = 0;
        if (bl2) {
            n5 = n6 / (76 + LINE_SEPARATOR_LEN);
            if (n5 * (76 + LINE_SEPARATOR_LEN) != n6) {
                ++n5;
            }
            n7 = n5 * LINE_SEPARATOR_LEN;
            n8 = LINE_SEPARATOR_LEN;
        }
        if (4 * (n4 = (n5 = n6 - n7) / 4) != n5) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int n9 = 0;
        int n10 = n4;
        if (n6 != 0) {
            if (string.charAt(n6 - 1 - n8) == '=') {
                ++n9;
                --n10;
            }
            if (string.charAt(n6 - 2 - n8) == '=') {
                ++n9;
            }
        }
        byte[] byArray2 = new byte[3 * n4 - n9];
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        for (n3 = 0; n3 < n10; ++n3) {
            if (bl2 && 76 == n13) {
                n11 += LINE_SEPARATOR_LEN;
                n13 = 4;
            } else {
                n13 += 4;
            }
            n2 = Base64Bytes.base64toInt(string.charAt(n11++), byArray);
            n = Base64Bytes.base64toInt(string.charAt(n11++), byArray);
            int n14 = Base64Bytes.base64toInt(string.charAt(n11++), byArray);
            int n15 = Base64Bytes.base64toInt(string.charAt(n11++), byArray);
            byArray2[n12++] = (byte)(n2 << 2 | n >> 4);
            byArray2[n12++] = (byte)(n << 4 | n14 >> 2);
            byArray2[n12++] = (byte)(n14 << 6 | n15);
        }
        if (n9 != 0) {
            if (bl2 && 76 == n13) {
                n11 += LINE_SEPARATOR_LEN;
            }
            n3 = Base64Bytes.base64toInt(string.charAt(n11++), byArray);
            n2 = Base64Bytes.base64toInt(string.charAt(n11++), byArray);
            byArray2[n12++] = (byte)(n3 << 2 | n2 >> 4);
            if (n9 == 1) {
                n = Base64Bytes.base64toInt(string.charAt(n11++), byArray);
                byArray2[n12++] = (byte)(n2 << 4 | n >> 2);
            }
        }
        return byArray2;
    }

    private static int base64toInt(char c, byte[] byArray) {
        byte by = byArray[c];
        if (by < 0) {
            throw new IllegalArgumentException("Illegal character " + c);
        }
        return by;
    }
}

