/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.enumerations;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class ArrayEnumerator
implements Enumeration,
Serializable,
Cloneable {
    private Object[] array;
    private int idx;

    public ArrayEnumerator(Object[] objectArray) {
        this.array = objectArray;
        this.idx = 0;
    }

    public boolean hasMoreElements() {
        return this.idx < this.array.length;
    }

    public Object nextElement() {
        try {
            return this.array[this.idx++];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NoSuchElementException();
        }
    }

    public int which() {
        if (this.idx == 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.idx - 1;
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Contents of enum not cloneable" + cloneNotSupportedException);
        }
    }
}

