/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.BitSet;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReferenceArray;
import weblogic.utils.Hex;
import weblogic.utils.StringUtils;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.utils.http.BytesToString;
import weblogic.utils.http.QueryParams;

public final class HttpParsing {
    static BitSet dontNeedEncoding;
    static final boolean VERBOSE = false;
    private static final EncodedStringCache encodedStringCache;
    private static final String platformEncoding;

    private HttpParsing() {
    }

    public static String[] getAuthInfo(String string) {
        int n;
        byte[] byArray;
        if (string == null) {
            return null;
        }
        String[] stringArray = StringUtils.split(string, ' ');
        if (stringArray.length < 2 || !"Basic".equals(stringArray[0]) || stringArray[1] == null) {
            return null;
        }
        try {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byArray = bASE64Decoder.decodeBuffer(stringArray[1]);
        }
        catch (IOException iOException) {
            return null;
        }
        for (n = 0; n < byArray.length && byArray[n] != 58; ++n) {
        }
        if (n >= byArray.length - 1) {
            return null;
        }
        String[] stringArray2 = new String[]{new String(byArray, 0, 0, n), new String(byArray, 0, ++n, byArray.length - n)};
        return stringArray2;
    }

    public static void parseQueryString(String string, Map map) {
        HttpParsing.parseQueryString(string, map, null);
    }

    public static void parseQueryString(String string, Map map, String string2) {
        int n = string.indexOf(35);
        if (n > 0) {
            string = string.substring(0, n);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.replace('+', ' '), "&");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            String[] stringArray = StringUtils.split(string3, '=');
            map.put(HttpParsing.unescape(stringArray[0], string2), HttpParsing.unescape(stringArray[1], string2));
        }
    }

    public static void parseQueryString(byte[] byArray, int n, int n2, Map map, String string) {
        int n3 = n + n2;
        boolean bl = BytesToString.is8BitUnicodeSubset(string);
        while (true) {
            String string2;
            String string3;
            int n4;
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            int n5 = -1;
            for (n4 = n; n4 < n3; ++n4) {
                if (byArray[n4] == 61 && bl2) {
                    n5 = n4;
                    bl2 = false;
                }
                if (byArray[n4] == 43 || byArray[n4] == 37 && n4 + 2 < n3 && Hex.isHexChar(byArray[n4 + 1]) && Hex.isHexChar(byArray[n4 + 2])) {
                    if (bl2) {
                        bl3 = true;
                    } else {
                        bl4 = true;
                    }
                }
                if (byArray[n4] == 38) break;
            }
            if (n5 >= 0) {
                string3 = HttpParsing.unescape(byArray, n, n5 - n, string, bl, bl3, true);
                string2 = HttpParsing.unescape(byArray, ++n5, n4 - n5, string, bl, bl4);
                map.put(string3, string2);
            } else if (n4 > n) {
                string3 = HttpParsing.unescape(byArray, n, n4 - n, string, bl, bl3, true);
                string2 = "";
                map.put(string3, string2);
            }
            if (++n4 >= n3) break;
            n = n4;
        }
    }

    public static void prependQueryString(String string, QueryParams queryParams, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.replace('+', ' '), "&");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        String[] stringArray = new String[n];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        int n3 = stringArray.length;
        while (--n3 >= 0) {
            String[] stringArray2 = StringUtils.split(stringArray[n3], '=');
            queryParams.prepend(HttpParsing.unescape(stringArray2[0], string2), HttpParsing.unescape(stringArray2[1], string2));
            stringArray[n3] = null;
        }
    }

    public static String makeURI(String string, String[][] stringArray) {
        return HttpParsing.makeURI(string, stringArray, null);
    }

    public static String makeURI(String string, String[][] stringArray, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = stringArray.length;
        if (string.indexOf(63) < 0) {
            stringBuilder.append('?');
        } else if (n > 0) {
            stringBuilder.append('&');
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(HttpParsing.isURLEncoded(stringArray[i][0]) ? stringArray[i][0] : HttpParsing.escape(stringArray[i][0], string2));
            stringBuilder.append('=');
            stringBuilder.append(HttpParsing.isURLEncoded(stringArray[i][1]) ? stringArray[i][1] : HttpParsing.escape(stringArray[i][1], string2));
            if (i >= n - 1) continue;
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }

    private static boolean isURLEncoded(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                return false;
            }
            if (dontNeedEncoding.get(c)) continue;
            if (c == '%' && i + 2 < n && Hex.isHexChar(string.charAt(i + 1)) && Hex.isHexChar(string.charAt(i + 2))) {
                i += 2;
                continue;
            }
            return false;
        }
        return true;
    }

    public static String escape(String string, String string2) {
        if (string2 != null) {
            String string3 = null;
            try {
                string3 = URLEncoder.encode(string, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string3 = URLEncoder.encode(string);
            }
            return string3;
        }
        return HttpParsing.escape(string);
    }

    public static String escape(String string) {
        int n = string.length();
        byte[] byArray = new byte[n];
        string.getBytes(0, n, byArray, 0);
        StringBuffer stringBuffer = new StringBuffer(byArray.length + 16);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (HttpParsing.isUnsafe(by) || by == 32) {
                stringBuffer.append("%" + Hex.asHex(by));
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        return HttpParsing.unescape(string, null);
    }

    public static String unescape(String string, String string2) {
        if (string.indexOf(37) < 0) {
            return string;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = platformEncoding;
        }
        int n = 0;
        byte[] byArray = string.getBytes();
        int n2 = byArray.length;
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            if (byArray[n3] == 37 && n3 + 2 < n2 && Hex.isHexChar(byArray[n3 + 1]) && Hex.isHexChar(byArray[n3 + 2])) {
                byArray[n] = (byte)((Hex.hexValueOf(byArray[n3 + 1]) << 4) + (Hex.hexValueOf(byArray[n3 + 2]) << 0));
                n3 += 2;
            } else {
                if (!(bl || byArray[n3] > 31 && byArray[n3] != 127)) {
                    string2 = System.getProperty("file.encoding");
                    bl = true;
                }
                byArray[n] = byArray[n3];
            }
            ++n3;
            ++n;
        }
        return BytesToString.newString(byArray, 0, n, string2);
    }

    private static String unescape(byte[] byArray, int n, int n2, String string, boolean bl, boolean bl2) {
        return HttpParsing.unescape(byArray, n, n2, string, bl, bl2, false);
    }

    private static String unescape(byte[] byArray, int n, int n2, String string, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            int n3 = n + n2;
            byte[] byArray2 = new byte[n2];
            int n4 = 0;
            for (int i = n; i < n3; ++i) {
                if (byArray[i] == 37 && i + 2 < n3 && Hex.isHexChar(byArray[i + 1]) && Hex.isHexChar(byArray[i + 2])) {
                    byArray2[n4++] = (byte)((Hex.hexValueOf(byArray[i + 1]) << 4) + (Hex.hexValueOf(byArray[i + 2]) << 0));
                    i += 2;
                    continue;
                }
                byArray2[n4++] = byArray[i] == 43 ? 32 : byArray[i];
            }
            byArray = byArray2;
            n = 0;
            n2 = n4;
        }
        if (bl) {
            if (bl3) {
                return encodedStringCache.getEncodedString(byArray, n, n2);
            }
            return BytesToString.newAsciiString(byArray, n, n2);
        }
        return BytesToString.newNonAsciiString(byArray, n, n2, string);
    }

    public static final boolean isUnsafe(int n) {
        if (n >= 0 && n <= 31 || n >= 127 && n <= 255) {
            return true;
        }
        switch (n) {
            case 34: 
            case 35: 
            case 37: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 92: 
            case 94: 
            case 96: 
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public static final String StripHTTPFieldValue(String string) {
        int n = string.indexOf(40);
        if (n > 0) {
            string = string.substring(0, n).trim();
        }
        if (string.length() > 2 && string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"') {
            string = string.substring(1, string.length() - 1).trim();
        }
        return string;
    }

    public static final String ensureStartingSlash(String string) {
        int n = string.length();
        if (n == 0) {
            return "/";
        }
        if (string.charAt(0) == '/') {
            return string;
        }
        return new StringBuffer(n + 1).append('/').append(string).toString();
    }

    public static final String ensureEndingSlash(String string) {
        int n = string.length();
        if (n == 0) {
            return "/";
        }
        if (string.charAt(n - 1) == '/') {
            return string;
        }
        return new StringBuffer(n + 1).append(string).append('/').toString();
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isWS(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static boolean isSpace(char c) {
        return c == '\t' || c == '\r' || c == '\n';
    }

    private static boolean isCTL(char c) {
        return c >= '\u0000' && c <= '\u001f' || c >= '\u007f';
    }

    private static boolean isTspecial(char c) {
        switch (c) {
            case '\t': 
            case ' ': 
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    public static boolean isTokenClean(String string) {
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (!HttpParsing.isCTL(c) && !HttpParsing.isTspecial(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNetscapeSpecial(char c) {
        return c == ';';
    }

    public static boolean isQuoted(String string) {
        if (string == null || string.length() < 2) {
            return false;
        }
        return string.charAt(0) == '\"' && string.charAt(string.length() - 1) == '\"';
    }

    static {
        int n;
        dontNeedEncoding = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            dontNeedEncoding.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            dontNeedEncoding.set(n);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dontNeedEncoding.set(91);
        dontNeedEncoding.set(93);
        Integer n2 = Integer.getInteger("weblogic.http.EncodedStringCacheMaxLen", 64);
        Integer n3 = Integer.getInteger("weblogic.http.EncodedStringCacheEntryCount", 64);
        encodedStringCache = new EncodedStringCache(n2, n3);
        platformEncoding = null;
        try {
            System.getProperty("file.encoding");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static class EncodedStringCache {
        AtomicReferenceArray<EncodedStringEntry>[] cache;
        volatile int nextToEvict;
        int maxBufferLen;
        int entryCount;

        EncodedStringCache(int n, int n2) {
            this.maxBufferLen = n;
            this.entryCount = n2;
            this.cache = new AtomicReferenceArray[n];
            for (int i = 0; i < n; ++i) {
                this.cache[i] = new AtomicReferenceArray(n2);
            }
        }

        String getEncodedString(byte[] byArray, int n, int n2) {
            int n3;
            Object object;
            if (n2 >= this.maxBufferLen) {
                return BytesToString.newAsciiString(byArray, n, n2);
            }
            AtomicReferenceArray<EncodedStringEntry> atomicReferenceArray = this.cache[n2];
            for (int i = 0; i < this.entryCount; ++i) {
                object = atomicReferenceArray.get(i);
                if (object == null) {
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                    String string = BytesToString.newAsciiString(byArray, n, n2);
                    atomicReferenceArray.set(i, new EncodedStringEntry(byArray2, string));
                    return string;
                }
                byte[] byArray3 = object.bytes;
                for (n3 = n2 - 1; n3 >= 0 && byArray[n + n3] == byArray3[n3]; --n3) {
                }
                if (n3 != -1) continue;
                return object.result;
            }
            object = new byte[n2];
            System.arraycopy(byArray, n, object, 0, n2);
            String string = BytesToString.newAsciiString(byArray, n, n2);
            n3 = this.nextToEvict++;
            if (n3 >= this.entryCount) {
                n3 = 0;
                this.nextToEvict = 0;
            }
            atomicReferenceArray.set(n3, new EncodedStringEntry((byte[])object, string));
            return string;
        }

        class EncodedStringEntry {
            byte[] bytes;
            String result;

            public EncodedStringEntry(byte[] byArray, String string) {
                this.bytes = byArray;
                this.result = string;
            }
        }
    }
}

