/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.http;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import weblogic.utils.StringUtils;
import weblogic.utils.http.BytesToString;
import weblogic.utils.http.HttpConstants;
import weblogic.utils.http.HttpParsing;
import weblogic.utils.http.HttpRequestParseException;
import weblogic.utils.io.FilenameEncoder;

public final class HttpRequestParser {
    private static final boolean VERBOSE = false;
    private static final String ENCODING = System.getProperty("file.encoding");
    private static final String URI_DECODE_ENCODING;
    private static final ByteBufferCache byteBufferCache;
    private String method;
    private String requestURI;
    private String normalizedURI;
    private String pathParameters;
    private String protocol;
    private boolean keepAlive;
    private int queryStringStart = -1;
    private int queryStringLength = -1;
    private int requestUriStart = -1;
    private int requestUriLength = -1;
    private int fullRequestUriStart = -1;
    private int fullRequestUriLength = -1;
    private int originalUriLength = -1;
    private final ArrayList headerNames = new ArrayList(16);
    private final ArrayList headerValues = new ArrayList(16);
    private byte[] buf;
    private int bufLen;
    private int pos = 0;

    public static String getURIDecodeEncoding() {
        return URI_DECODE_ENCODING;
    }

    public HttpRequestParser() {
        this.bufLen = 0;
    }

    public HttpRequestParser(byte[] byArray, int n) throws HttpRequestParseException {
        this.parse(byArray, n);
    }

    public void parse(byte[] byArray, int n) throws HttpRequestParseException {
        this.buf = byArray;
        this.bufLen = n;
        this.parse();
        byArray = null;
    }

    public void reset() {
        this.method = null;
        this.requestURI = null;
        this.normalizedURI = null;
        this.pathParameters = null;
        this.protocol = null;
        this.keepAlive = false;
        this.headerNames.clear();
        this.headerValues.clear();
        this.buf = null;
        this.bufLen = 0;
        this.pos = 0;
        this.queryStringStart = -1;
        this.queryStringLength = -1;
        this.requestUriStart = -1;
        this.requestUriLength = -1;
        this.originalUriLength = -1;
    }

    public HttpRequestParser(String string, String string2, String string3) {
        this();
        this.method = string;
        this.protocol = string2;
        this.requestURI = string3;
    }

    public String toString() {
        return "[HttpRequestParser] method: " + this.method + " requestURI: " + this.requestURI + " protocol: " + this.protocol;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public boolean isMethodSafe() {
        return this.isMethodGet() || this.isMethodHead();
    }

    public boolean isMethodGet() {
        return "GET".equals(this.getMethod());
    }

    public boolean isMethodTrace() {
        return "TRACE".equals(this.getMethod());
    }

    public boolean isMethodPost() {
        return "POST".equals(this.getMethod());
    }

    public boolean isMethodHead() {
        return "HEAD".equals(this.getMethod());
    }

    public boolean isMethodOptions() {
        return "OPTIONS".equals(this.getMethod());
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getPathParameters() {
        return this.pathParameters;
    }

    public String getNormalizedURI() {
        return this.normalizedURI;
    }

    public byte[] getHttpRequestBuffer() {
        return this.buf;
    }

    public int getQeuryStringStart() {
        return this.queryStringStart;
    }

    public int getQueryStringLength() {
        return this.queryStringLength;
    }

    public int getRequestUriStart() {
        return this.requestUriStart;
    }

    public int getRequestUriLength() {
        return this.requestUriLength;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isProtocolVersion_1_1() {
        return "HTTP/1.1".equals(this.getProtocol());
    }

    public ArrayList getHeaderNames() {
        return this.headerNames;
    }

    public ArrayList getHeaderValues() {
        return this.headerValues;
    }

    public byte[] getHeader(String string) {
        for (int i = 0; i < this.headerNames.size(); ++i) {
            String string2 = (String)this.headerNames.get(i);
            if (!string.equalsIgnoreCase(string2)) continue;
            return (byte[])this.headerValues.get(i);
        }
        return null;
    }

    public int getHeaderSize() {
        return this.pos;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public ByteBuffer getOriginalRequestUriBytes() {
        return ByteBuffer.wrap(this.buf, this.requestUriStart, this.originalUriLength);
    }

    public ByteBuffer getFullRequrestUriBytes() {
        return ByteBuffer.wrap(this.buf, 0, this.fullRequestUriLength);
    }

    private boolean isCR(byte by) {
        return by == 13;
    }

    private boolean isLF(byte by) {
        return by == 10;
    }

    private boolean isCRLF() {
        return this.isCR(this.buf[this.pos]) || this.isLF(this.buf[this.pos]);
    }

    private boolean isSpace() {
        return this.buf[this.pos] == 32;
    }

    private boolean isSpaceTab(byte by) {
        return by == 32 || by == 9;
    }

    private boolean isSpaceTab() {
        return this.isSpaceTab(this.buf[this.pos]);
    }

    private boolean isSlash() {
        return this.buf[this.pos] == 47;
    }

    private boolean cmp(byte[] byArray, int n, byte[] byArray2) {
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private int incPos(int n) {
        this.pos += n;
        this.checkOverflow(this.pos);
        return this.pos;
    }

    private void consumeSpaces() {
        while (this.isSpace()) {
            this.incPos(1);
        }
    }

    private void checkOverflow(int n) {
        if (n > this.bufLen) {
            throw new ArrayIndexOutOfBoundsException("overflow detected");
        }
    }

    private void parse() throws HttpRequestParseException {
        try {
            this.startLine();
            this.headers();
            this.validate();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            throw new HttpRequestParseException("Request parsing failed", arrayIndexOutOfBoundsException, this);
        }
    }

    private void validate() throws HttpRequestParseException {
        if (this.method == null || this.method.length() == 0) {
            throw new HttpRequestParseException("Method was not set");
        }
        if (this.protocol == null || this.protocol.length() == 0) {
            throw new HttpRequestParseException("Protocol was not set");
        }
    }

    private void startLine() throws HttpRequestParseException {
        this.oldCRLF();
        this.fullRequestUriStart = this.pos;
        this.method();
        this.uri_protocol();
        this.fullRequestUriLength = this.pos;
        this.crlf();
    }

    private int crlf() throws HttpRequestParseException {
        switch (this.buf[this.pos++]) {
            case 13: {
                if (this.buf[this.pos++] == 10) {
                    this.checkOverflow(this.pos);
                    return 2;
                }
                this.checkOverflow(this.pos);
                break;
            }
            case 10: {
                if (this.buf[this.pos] == 13) {
                    this.incPos(1);
                    return 2;
                }
                this.checkOverflow(this.pos);
                return 1;
            }
        }
        throw new HttpRequestParseException("Expected CRLF", this);
    }

    private void oldCRLF() {
        while (this.isCRLF()) {
            this.incPos(1);
        }
    }

    private void method() {
        int n = this.pos;
        while (!this.isSpace()) {
            this.incPos(1);
        }
        this.method = this.buf[n] == 71 && this.buf[n + 1] == 69 && this.buf[n + 2] == 84 && this.buf[n + 3] == 32 ? "GET" : (this.buf[n] == 80 && this.buf[n + 1] == 79 && this.buf[n + 2] == 83 && this.buf[n + 3] == 84 && this.buf[n + 4] == 32 ? "POST" : (this.buf[n] == 80 && this.buf[n + 1] == 85 && this.buf[n + 2] == 84 && this.buf[n + 3] == 32 ? "PUT" : (this.buf[n] == 72 && this.buf[n + 1] == 69 && this.buf[n + 2] == 65 && this.buf[n + 3] == 68 ? "HEAD" : (this.buf[n] == 84 && this.buf[n + 1] == 82 && this.buf[n + 2] == 65 && this.buf[n + 3] == 67 && this.buf[n + 4] == 69 && this.buf[n + 5] == 32 ? "TRACE" : StringUtils.getString(this.buf, n, this.pos - n)))));
    }

    private void decodeURI(int n, int n2, int n3) {
        if (n2 != -1) {
            this.pathParameters = BytesToString.newString(this.buf, n2, n3 - n2, ENCODING);
            n3 = n2;
        }
        this.requestUriStart = n;
        this.requestUriLength = n3 - n;
        this.requestURI = BytesToString.newString(this.buf, this.requestUriStart, this.requestUriLength, ENCODING);
        String string = HttpParsing.unescape(this.requestURI, HttpRequestParser.getURIDecodeEncoding());
        this.normalizedURI = FilenameEncoder.resolveRelativeURIPath(string, true);
        if (this.normalizedURI != null) {
            this.normalizedURI = HttpParsing.ensureStartingSlash(this.normalizedURI);
        }
    }

    private void parseProtocol(int n, int n2) {
        if (n2 - n == 8 && this.buf[n] == 72) {
            byte by = this.buf[n + 7];
            if (by == 48) {
                this.protocol = "HTTP/1.0";
                return;
            }
            if (by == 49) {
                this.protocol = "HTTP/1.1";
                return;
            }
        }
        this.protocol = StringUtils.getString(this.buf, n, n2 - n);
    }

    private boolean isAbsHTTP() {
        try {
            this.checkOverflow(this.pos + 6);
            return this.buf[this.pos] == 104 && this.buf[this.pos + 1] == 116 && this.buf[this.pos + 2] == 116 && this.buf[this.pos + 3] == 112 && this.buf[this.pos + 4] == 58 && this.buf[this.pos + 5] == 47 && this.buf[this.pos + 6] == 47;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    private boolean isAbsHTTPS() {
        try {
            this.checkOverflow(this.pos + 7);
            return this.buf[this.pos] == 104 && this.buf[this.pos + 1] == 116 && this.buf[this.pos + 2] == 116 && this.buf[this.pos + 3] == 112 && this.buf[this.pos + 4] == 115 && this.buf[this.pos + 5] == 58 && this.buf[this.pos + 6] == 47 && this.buf[this.pos + 7] == 47;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
    }

    private void skipAbsURI() {
        block3: {
            block2: {
                if (!this.isAbsHTTP()) break block2;
                this.incPos(7);
                while (!this.isSlash()) {
                    this.incPos(1);
                }
                break block3;
            }
            if (!this.isAbsHTTPS()) break block3;
            this.incPos(8);
            while (!this.isSlash()) {
                this.incPos(1);
            }
        }
    }

    private void uri_protocol() throws HttpRequestParseException {
        boolean bl = false;
        this.consumeSpaces();
        this.skipAbsURI();
        int n = -1;
        int n2 = -1;
        int n3 = this.pos;
        while (!this.isSpace() && !this.isCRLF()) {
            if (this.buf[this.pos] == 63 && n == -1) {
                n = this.pos;
            } else if (this.buf[this.pos] == 59 && n == -1 && n2 == -1) {
                n2 = this.pos;
            } else if (this.buf[this.pos] == 60 && n == -1) {
                bl = true;
            }
            this.incPos(1);
        }
        int n4 = this.pos;
        this.consumeSpaces();
        if (this.isCRLF()) {
            this.protocol = "HTTP/0.9";
        } else {
            int n5 = this.pos;
            int n6 = -1;
            while (true) {
                if (this.isCRLF()) break;
                if (this.isSpace()) {
                    n4 = this.pos;
                    this.consumeSpaces();
                    n5 = this.pos;
                    continue;
                }
                if (this.buf[this.pos] == 63) {
                    n = n == -1 ? this.pos : n;
                    this.incPos(1);
                    continue;
                }
                if (this.buf[this.pos] == 59) {
                    n2 = n == -1 && n2 == -1 ? this.pos : n2;
                    this.incPos(1);
                    continue;
                }
                this.incPos(1);
            }
            n6 = this.pos;
            this.parseProtocol(n5, n6);
        }
        this.keepAlive = "HTTP/1.1".equalsIgnoreCase(this.protocol);
        if (n > n4) {
            n = -1;
        }
        this.originalUriLength = n4 - n3;
        if (n == -1) {
            this.decodeURI(n3, n2, n4);
        } else {
            this.decodeURI(n3, n2, n);
            this.queryStringStart = n + 1;
            this.queryStringLength = n4 - (n + 1);
        }
        if (bl) {
            throw new HttpRequestParseException("Request contains XSS script", this);
        }
    }

    private void headers() throws HttpRequestParseException {
        while (true) {
            if (this.isCRLF()) {
                while (this.pos < this.bufLen && this.isCRLF()) {
                    this.incPos(1);
                }
                return;
            }
            this.header();
        }
    }

    private void header() throws HttpRequestParseException {
        String string = this.headerName();
        this.headerColon();
        byte[] byArray = this.headerValue();
        this.headerNames.add(string);
        this.headerValues.add(byArray);
        this.processSpecialHeaders(string, byArray);
        this.crlf();
    }

    private void processSpecialHeaders(String string, byte[] byArray) {
        switch (string.length()) {
            case 10: {
                if (!"Connection".equalsIgnoreCase(string)) break;
                this.connection(byArray);
                break;
            }
        }
    }

    private boolean startsWith(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray[i + n] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean contains(byte[] byArray, byte[] byArray2) {
        if (byArray.length < byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length - byArray2.length + 1; ++i) {
            if (!this.startsWith(byArray, byArray2, i)) continue;
            return true;
        }
        return false;
    }

    private void connection(byte[] byArray) {
        if (this.contains(byArray, HttpConstants.KEEP_ALIVE_BYTES)) {
            this.keepAlive = true;
        } else if (this.contains(byArray, HttpConstants.KEEP_ALIVE_IE_BYTES)) {
            this.keepAlive = true;
        } else {
            String string = StringUtils.getString(byArray);
            if (StringUtils.indexOfIgnoreCase(string, "keep-alive") >= 0) {
                this.keepAlive = true;
            } else if (StringUtils.indexOfIgnoreCase(string, "close") >= 0) {
                this.keepAlive = false;
            }
        }
    }

    private String headerName() throws HttpRequestParseException {
        int n = this.pos;
        boolean bl = false;
        while (this.buf[this.pos] != 58) {
            if (this.buf[this.pos] == 32) {
                bl = true;
            }
            this.incPos(1);
        }
        int n2 = this.pos - n;
        if (bl) {
            throw new HttpRequestParseException("Header name '" + StringUtils.getString(this.buf, n, n2) + "' has a space character.", this);
        }
        switch (n2) {
            case 4: {
                if (!this.cmp(this.buf, n, HttpConstants.HOST_HEADER_BYTES)) break;
                return "Host";
            }
            case 6: {
                if (this.cmp(this.buf, n, HttpConstants.COOKIE_HEADER_BYTES)) {
                    return "Cookie";
                }
                if (!this.cmp(this.buf, n, HttpConstants.EXPECT_HEADER_BYTES)) break;
                return "Expect";
            }
            case 9: {
                if (!this.cmp(this.buf, n, HttpConstants.AUTH_TYPE_HEADER_BYTES)) break;
                return "AUTH_TYPE";
            }
            case 10: {
                if (this.cmp(this.buf, n, HttpConstants.CONNECTION_HEADER_BYTES)) {
                    return "Connection";
                }
                if (!this.cmp(this.buf, n, HttpConstants.USER_AGENT_HEADER_BYTES)) break;
                return "User-Agent";
            }
            case 12: {
                if (!this.cmp(this.buf, n, HttpConstants.CONTENT_TYPE_HEADER_BYTES)) break;
                return "Content-Type";
            }
            case 13: {
                if (!this.cmp(this.buf, n, HttpConstants.AUTHORIZATION_HEADER_BYTES)) break;
                return "Authorization";
            }
            case 14: {
                if (!this.cmp(this.buf, n, HttpConstants.CONTENT_LENGTH_HEADER_BYTES)) break;
                return "Content-Length";
            }
            case 17: {
                if (!this.cmp(this.buf, n, HttpConstants.TRANSFER_ENCODING_HEADER_BYTES)) break;
                return "Transfer-Encoding";
            }
        }
        return StringUtils.getString(this.buf, n, n2);
    }

    private void validateHeaderNameBytes(byte[] byArray, int n, int n2) throws HttpRequestParseException {
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] != 32) continue;
            throw new HttpRequestParseException("Header name '" + StringUtils.getString(byArray, n, n2) + "' has a space character.", this);
        }
    }

    private void headerColon() throws HttpRequestParseException {
        this.consumeSpaces();
        if (this.buf[this.pos++] != 58) {
            throw new HttpRequestParseException("Expected : after header name but found " + (char)this.buf[this.pos - 1], this);
        }
        this.consumeSpaces();
    }

    private byte[] headerValue() throws HttpRequestParseException {
        int n;
        int n2;
        block0: while (true) {
            n2 = this.pos;
            if (this.isCRLF()) {
                this.crlf();
            }
            if (!this.isSpaceTab()) break;
            while (true) {
                if (!this.isSpaceTab()) continue block0;
                this.incPos(1);
            }
            break;
        }
        this.pos = n2;
        n2 = this.pos;
        int n3 = 0;
        while (true) {
            if (!this.isCRLF()) {
                this.incPos(1);
                continue;
            }
            n = this.pos;
            int n4 = this.crlf();
            if (!this.isSpaceTab()) break;
            while (this.isSpaceTab(this.buf[this.pos + 1])) {
                this.incPos(1);
                ++n4;
            }
            n3 += n4;
        }
        this.pos = n;
        if (n3 == 0) {
            return byteBufferCache.getByteBuffer(this.buf, n2, this.pos - n2);
        }
        n = this.pos - n2 - n3;
        byte[] byArray = new byte[n];
        int n5 = 0;
        for (int i = n2; i < this.pos; ++i) {
            if (this.isCR(this.buf[i]) && this.isLF(this.buf[i + 1]) && this.isSpaceTab(this.buf[i + 2]) || this.isLF(this.buf[i]) && this.isCR(this.buf[i + 1]) && this.isSpaceTab(this.buf[i + 2])) {
                ++i;
                while (this.isSpaceTab(this.buf[i + 2])) {
                    ++i;
                }
                continue;
            }
            if (this.isLF(this.buf[i]) && this.isSpaceTab(this.buf[i + 1])) {
                while (this.isSpaceTab(this.buf[i + 2])) {
                    ++i;
                }
                continue;
            }
            byArray[n5++] = this.buf[i];
        }
        return byArray;
    }

    static boolean eq(String string, String string2, int n) {
        return string == string2 || string2.regionMatches(true, 0, string, 0, n);
    }

    static {
        String string = System.getProperty("weblogic.http.URIDecodeEncoding");
        URI_DECODE_ENCODING = string != null && (string = string.trim()).length() != 0 ? string : "UTF-8";
        Integer n = Integer.getInteger("weblogic.http.ByteBufferMaxLen", 128);
        Integer n2 = Integer.getInteger("weblogic.http.ByteBufferEntryCount", 16);
        byteBufferCache = new ByteBufferCache(n, n2);
    }

    static class ByteBufferCache {
        AtomicReferenceArray<byte[]>[] cache;
        volatile int nextToEvict;
        int maxBufferLen;
        int entryCount;
        private static final byte[] JSESSION_START_BYTES = "JSES".getBytes();

        ByteBufferCache(int n, int n2) {
            this.maxBufferLen = n;
            this.entryCount = n2;
            this.cache = new AtomicReferenceArray[n];
            for (int i = 0; i < n; ++i) {
                this.cache[i] = new AtomicReferenceArray(n2);
            }
        }

        byte[] getByteBuffer(byte[] byArray, int n, int n2) {
            if (n2 >= this.maxBufferLen || this.isFiltered(byArray, n, n2)) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                return byArray2;
            }
            AtomicReferenceArray<byte[]> atomicReferenceArray = this.cache[n2];
            for (int i = 0; i < this.entryCount; ++i) {
                int n3;
                byte[] byArray3 = atomicReferenceArray.get(i);
                if (byArray3 == null) {
                    byte[] byArray4 = new byte[n2];
                    System.arraycopy(byArray, n, byArray4, 0, n2);
                    atomicReferenceArray.set(i, byArray4);
                    return byArray4;
                }
                for (n3 = n2 - 1; n3 >= 0 && byArray[n + n3] == byArray3[n3]; --n3) {
                }
                if (n3 != -1) continue;
                return byArray3;
            }
            byte[] byArray5 = new byte[n2];
            System.arraycopy(byArray, n, byArray5, 0, n2);
            int n4 = this.nextToEvict++;
            if (n4 >= this.entryCount) {
                n4 = 0;
                this.nextToEvict = 0;
            }
            atomicReferenceArray.set(n4, byArray5);
            return byArray5;
        }

        private boolean isFiltered(byte[] byArray, int n, int n2) {
            return n2 > 24 && JSESSION_START_BYTES[0] == byArray[n] && JSESSION_START_BYTES[1] == byArray[n + 1] && JSESSION_START_BYTES[2] == byArray[n + 2] && JSESSION_START_BYTES[3] == byArray[n + 3];
        }
    }
}

