/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkOutput;
import weblogic.utils.io.ChunkedDataInputStream;
import weblogic.utils.io.ChunkedOutputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.StringOutput;

public class ChunkedDataOutputStream
extends ChunkedOutputStream
implements DataOutput,
StringOutput,
ChunkOutput {
    private static final int CHAR_BUF_SIZE = 256;
    private char[] cbuf;

    public final void writeBoolean(boolean bl) {
        this.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) {
        this.write(n);
    }

    public final void writeShort(int n) {
        int n2 = this.chunkPos;
        if (n2 <= Chunk.CHUNK_SIZE - 2) {
            byte[] byArray = this.current.buf;
            byArray[n2++] = (byte)(n >>> 8);
            byArray[n2++] = (byte)(n >>> 0);
            this.chunkPos = n2;
            return;
        }
        try {
            DataIO.writeShort(this, n);
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    public final void writeChar(int n) {
        int n2 = this.chunkPos;
        if (n2 <= Chunk.CHUNK_SIZE - 2) {
            byte[] byArray = this.current.buf;
            byArray[n2++] = (byte)(n >>> 8);
            byArray[n2++] = (byte)(n >>> 0);
            this.chunkPos = n2;
            return;
        }
        try {
            DataIO.writeChar(this, n);
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    public final void writeInt(int n) {
        int n2 = this.chunkPos;
        if (n2 <= Chunk.CHUNK_SIZE - 4) {
            byte[] byArray = this.current.buf;
            byArray[n2++] = (byte)(n >>> 24);
            byArray[n2++] = (byte)(n >>> 16);
            byArray[n2++] = (byte)(n >>> 8);
            byArray[n2++] = (byte)(n >>> 0);
            this.chunkPos = n2;
            return;
        }
        try {
            DataIO.writeInt(this, n);
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    public final void writeLong(long l) {
        int n = this.chunkPos;
        if (n <= Chunk.CHUNK_SIZE - 8) {
            byte[] byArray = this.current.buf;
            byArray[n++] = (byte)(l >>> 56);
            byArray[n++] = (byte)(l >>> 48);
            byArray[n++] = (byte)(l >>> 40);
            byArray[n++] = (byte)(l >>> 32);
            byArray[n++] = (byte)(l >>> 24);
            byArray[n++] = (byte)(l >>> 16);
            byArray[n++] = (byte)(l >>> 8);
            byArray[n++] = (byte)(l >>> 0);
            this.chunkPos = n;
            return;
        }
        try {
            DataIO.writeLong(this, l);
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }

    public final void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            if (this.chunkPos == Chunk.CHUNK_SIZE) {
                this.advance();
            }
            n = Math.min(Chunk.CHUNK_SIZE - this.chunkPos, n2 - i);
            this.getBytes(string, i, i + n, this.current.buf, this.chunkPos);
            this.chunkPos += n;
        }
    }

    public final void writeChars(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.writeChar(c);
        }
    }

    public final void writeUTF(String string) throws IOException {
        int n = this.chunkPos;
        Chunk chunk = this.current;
        this.writeShort(0);
        int n2 = this.writeUTFChars(string);
        int n3 = this.chunkPos;
        int n4 = this.streamPos;
        Chunk chunk2 = this.current;
        this.current = chunk;
        this.chunkPos = n;
        if (n2 > 65535) {
            this.current.end = this.chunkPos;
            throw new UTFDataFormatException("String too long: " + n2);
        }
        this.writeShort(n2);
        this.chunkPos = n3;
        this.streamPos = n4;
        this.current = chunk2;
    }

    protected void getBytes(String string, int n, int n2, byte[] byArray, int n3) {
        string.getBytes(n, n2, byArray, n3);
    }

    private int writeUTFChars(String string) throws IOException {
        int n = string.length();
        if (n > 0) {
            this.createCharBuffer();
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            while (n3 < n && this.chunkPos < Chunk.CHUNK_SIZE - 3) {
                int n4;
                int n5 = Math.min(256, n - n3);
                string.getChars(n3, n3 + n5, this.cbuf, 0);
                int n6 = this.chunkPos;
                for (n4 = 0; n4 < n5 && n6 < Chunk.CHUNK_SIZE - 3; ++n4) {
                    char c = this.cbuf[n4];
                    if (c >= '\u0001' && c <= '\u007f') {
                        this.current.buf[n6++] = (byte)c;
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.current.buf[n6++] = (byte)(0xE0 | c >> 12 & 0xF);
                        this.current.buf[n6++] = (byte)(0x80 | c >> 6 & 0x3F);
                        this.current.buf[n6++] = (byte)(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.current.buf[n6++] = (byte)(0xC0 | c >> 6 & 0x1F);
                    this.current.buf[n6++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
                n2 += n6 - this.chunkPos;
                this.chunkPos = n6;
                n3 += n4;
            }
            while (n3 < n && this.chunkPos >= Chunk.CHUNK_SIZE - 3) {
                n2 += DataIO.writeUTF((OutputStream)this, string.charAt(n3++));
            }
        }
        return n2;
    }

    private void createCharBuffer() {
        if (this.cbuf == null) {
            this.cbuf = new char[256];
        }
    }

    public final void writeUTF8(String string) {
        if (this.isASCII(string)) {
            this.writeInt(string.length());
            this.writeBytes(string);
        } else {
            this.writeUTF8String(string);
        }
    }

    private boolean isASCII(String string) {
        int n;
        int n2 = string.length();
        if (n2 > 0) {
            this.createCharBuffer();
        }
        for (int i = 0; i < n2; i += n) {
            n = Math.min(256, n2 - i);
            string.getChars(i, i + n, this.cbuf, 0);
            for (int j = 0; j < n; ++j) {
                char c = this.cbuf[j];
                if ((c & 0xFF80) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private final void writeUTF8String(String string) {
        int n = this.chunkPos;
        Chunk chunk = this.current;
        this.writeInt(0);
        int n2 = this.writeUTF8Chars(string);
        int n3 = this.chunkPos;
        int n4 = this.streamPos;
        Chunk chunk2 = this.current;
        this.current = chunk;
        this.chunkPos = n;
        this.writeInt(n2);
        this.chunkPos = n3;
        this.streamPos = n4;
        this.current = chunk2;
    }

    private int writeUTF8Chars(String string) {
        int n = string.length();
        if (n > 0) {
            this.createCharBuffer();
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            while (n3 < n && this.chunkPos < Chunk.CHUNK_SIZE - 3) {
                int n4;
                int n5 = Math.min(256, n - n3);
                string.getChars(n3, n3 + n5, this.cbuf, 0);
                int n6 = this.chunkPos;
                for (n4 = 0; n4 < n5 && n6 < Chunk.CHUNK_SIZE - 3; ++n4) {
                    char c = this.cbuf[n4];
                    if ((c & 0xFF80) == 0) {
                        this.current.buf[n6++] = (byte)c;
                        continue;
                    }
                    if ((c & 0xF800) == 0) {
                        this.current.buf[n6++] = (byte)(0xC0 | c >> 6 & 0x1F);
                        this.current.buf[n6++] = (byte)(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.current.buf[n6++] = (byte)(0xE0 | c >> 12 & 0xF);
                    this.current.buf[n6++] = (byte)(0x80 | c >> 6 & 0x3F);
                    this.current.buf[n6++] = (byte)(0x80 | c >> 0 & 0x3F);
                }
                n2 += n6 - this.chunkPos;
                this.chunkPos = n6;
                n3 += n4;
            }
            while (n3 < n && this.chunkPos >= Chunk.CHUNK_SIZE - 3) {
                n2 += this.writeUTF8(string.charAt(n3++));
            }
        }
        return n2;
    }

    private final int writeUTF8(int n) {
        if ((n & 0xFF80) == 0) {
            this.write((byte)n);
            return 1;
        }
        if ((n & 0xF800) == 0) {
            this.write((byte)(0xC0 | n >> 6 & 0x1F));
            this.write((byte)(0x80 | n >> 0 & 0x3F));
            return 2;
        }
        this.write((byte)(0xE0 | n >> 12 & 0xF));
        this.write((byte)(0x80 | n >> 6 & 0x3F));
        this.write((byte)(0x80 | n >> 0 & 0x3F));
        return 3;
    }

    public final void writeLength(int n) {
        int n2 = this.chunkPos;
        if (n2 <= Chunk.CHUNK_SIZE - 5) {
            byte[] byArray = this.current.buf;
            if (n >= 0) {
                if (n < 254) {
                    byArray[n2++] = (byte)n;
                    this.chunkPos = n2;
                    return;
                }
                if (n <= 65535) {
                    byArray[n2++] = -2;
                    byArray[n2++] = (byte)(n >> 8);
                    byArray[n2++] = (byte)(n & 0xFF);
                    this.chunkPos = n2;
                    return;
                }
            }
            byArray[n2++] = -1;
            byArray[n2++] = (byte)(n >>> 24);
            byArray[n2++] = (byte)(n >>> 16);
            byArray[n2++] = (byte)(n >>> 8);
            byArray[n2++] = (byte)(n >>> 0);
            this.chunkPos = n2;
            return;
        }
        try {
            DataIO.writeLength(this, n);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public final void writeASCII(String string) {
        this.writeLength(string.length());
        this.writeBytes(string);
    }

    public final void writeChunks(Chunk chunk) {
        this.current.end = Math.max(this.current.end, this.chunkPos);
        Chunk chunk2 = chunk;
        int n = 0;
        while (chunk.next != null) {
            n += chunk.end;
            chunk = chunk.next;
        }
        this.writeInt(n += chunk.end);
        this.current.end = this.chunkPos;
        this.current.next = chunk2;
        this.chunkPos = chunk.end;
        this.current = chunk;
        this.streamPos = this.streamPos + n - this.chunkPos;
    }

    public final ChunkedDataInputStream makeChunkedDataInputStream() {
        return new ChunkedDataInputStream(this.getChunks(), 0);
    }
}

