/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import weblogic.utils.Debug;
import weblogic.utils.collections.Stack;
import weblogic.utils.io.Chunk;
import weblogic.utils.io.ChunkInputStreamAccess;
import weblogic.utils.io.ChunkedDataInputStream;
import weblogic.utils.io.DataIO;
import weblogic.utils.io.ObjectInput;
import weblogic.utils.io.ObjectStreamClass;
import weblogic.utils.io.Replacer;
import weblogic.utils.io.StringInput;

public class ChunkedObjectInputStream
extends ChunkedDataInputStream
implements ObjectInput {
    private static final boolean DEBUG = false;
    protected Class lastClass;
    private ObjectInputStream objectStream;
    private int curEndEnvelope = -1;
    private final Stack externalizableInfos = new Stack();
    private String curExternalizableName;
    private Replacer replacer;

    public ChunkedObjectInputStream(Chunk chunk, int n) throws IOException {
        super(chunk, n);
        this.initNestedStream();
    }

    protected ChunkedObjectInputStream() throws IOException {
        this.objectStream = new NestedObjectInputStream(this);
    }

    protected void initNestedStream() throws IOException {
        this.objectStream = new NestedObjectInputStream(this);
    }

    protected Class resolveClass(java.io.ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        return this.lastClass;
    }

    public final void setReplacer(Replacer replacer) {
        this.replacer = replacer;
    }

    protected final Object resolveObject(Object object) throws IOException {
        return this.replacer == null ? object : this.replacer.resolveObject(object);
    }

    protected java.io.ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        String string = this.readUTF();
        long l = this.readLong();
        String string2 = this.readUTF();
        Class clazz = this.loadClass(string, string2);
        if (!Serializable.class.isAssignableFrom(clazz)) {
            java.io.ObjectStreamClass objectStreamClass = java.io.ObjectStreamClass.lookup(clazz);
            this.lastClass = objectStreamClass.forClass();
            return objectStreamClass;
        }
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(clazz);
        if (objectStreamClass.getSerialVersionUID() != l) {
            throw new InvalidClassException(string, "Expected uid: '" + l + ", found uid: '" + objectStreamClass.getSerialVersionUID() + "'");
        }
        this.lastClass = objectStreamClass.forClass();
        return objectStreamClass.getObjectStreamClass();
    }

    protected Class loadClass(String string, String string2) throws ClassNotFoundException {
        return Class.forName(string, false, Thread.currentThread().getContextClassLoader());
    }

    private void pushExternalizableInfo(int n, String string) {
        if (this.curEndEnvelope != -1) {
            this.externalizableInfos.push(new ExternalizableInfo(this.curEndEnvelope, this.curExternalizableName));
        }
        this.curEndEnvelope = n;
        this.curExternalizableName = string;
    }

    private void popExternalizableInfo() {
        if (this.externalizableInfos.isEmpty()) {
            this.curEndEnvelope = -1;
            this.curExternalizableName = null;
        } else {
            ExternalizableInfo externalizableInfo = (ExternalizableInfo)this.externalizableInfos.pop();
            this.curEndEnvelope = externalizableInfo.endEnvelope;
            this.curExternalizableName = externalizableInfo.name;
        }
    }

    public final void init(Chunk chunk, int n) {
        super.init(chunk, n);
        this.lastClass = null;
    }

    protected void ensureAvailable(int n) throws IOException {
        this.checkIfReadPastEnvelope(n);
    }

    private void checkIfReadPastEnvelope(int n) throws EOFException {
        if (this.curEndEnvelope > 0 && this.pos() + n > this.curEndEnvelope) {
            throw new EOFException("Externalizable (" + this.curExternalizableName + ") reads too much data.");
        }
    }

    public final int available() {
        int n = super.available();
        if (this.curEndEnvelope > 0 && this.pos() + n > this.curEndEnvelope) {
            return this.curEndEnvelope - this.pos();
        }
        return n;
    }

    public final int read() throws IOException {
        if (this.curEndEnvelope > 0 && this.pos() == this.curEndEnvelope) {
            return -1;
        }
        return super.read();
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.curEndEnvelope > 0 && this.pos() + n2 > this.curEndEnvelope) {
            n2 = this.curEndEnvelope - this.pos();
        }
        return super.read(byArray, n, n2);
    }

    public final long skip(long l) throws IOException {
        this.checkIfReadPastEnvelope((int)l);
        return super.skip(l);
    }

    public final byte readByte() throws IOException {
        this.checkIfReadPastEnvelope(1);
        return super.readByte();
    }

    public final short readShort() throws IOException {
        this.checkIfReadPastEnvelope(2);
        return super.readShort();
    }

    public final int readUnsignedShort() throws IOException {
        this.checkIfReadPastEnvelope(2);
        return super.readUnsignedShort();
    }

    public final char readChar() throws IOException {
        this.checkIfReadPastEnvelope(2);
        return super.readChar();
    }

    public final int readInt() throws IOException {
        this.checkIfReadPastEnvelope(4);
        return super.readInt();
    }

    public final int readLength() throws IOException {
        if (this.curEndEnvelope == -1 || this.curEndEnvelope >= this.pos() + 5) {
            return super.readLength();
        }
        return DataIO.readLength(this);
    }

    public final Object readObject(Class clazz) throws IOException, ClassNotFoundException {
        return this.readObject();
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        return this.getInputStream().readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object readObjectFromPreDiabloPeer() throws IOException, ClassNotFoundException {
        block2: {
            byte by = this.readByte();
            if (by != 4) break block2;
            java.io.ObjectStreamClass objectStreamClass = this.readClassDescriptor();
            Class clazz = this.resolveClass(objectStreamClass);
            ObjectStreamClass objectStreamClass2 = ObjectStreamClass.lookup(clazz);
            Externalizable externalizable = (Externalizable)objectStreamClass2.newInstance();
            int n = this.readInt();
            int n2 = this.pos();
            this.pushExternalizableInfo(n2 + n, clazz.getName());
            try {
                externalizable.readExternal(this);
            }
            catch (Throwable throwable) {
                int n3 = this.curEndEnvelope - this.pos();
                this.popExternalizableInfo();
                Debug.assertion(n3 >= 0);
                this.skip(n3);
                throw throwable;
            }
            int n4 = this.curEndEnvelope - this.pos();
            this.popExternalizableInfo();
            Debug.assertion(n4 >= 0);
            this.skip(n4);
            return this.resolveObject(objectStreamClass2.readResolve(externalizable));
        }
        return this.getInputStream().readObject();
    }

    public ObjectInputStream getInputStream() {
        Debug.assertion(this.objectStream != null);
        return this.objectStream;
    }

    protected class NestedObjectInputStream
    extends ObjectInputStream
    implements ChunkInputStreamAccess,
    StringInput,
    ObjectInput {
        protected NestedObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
            try {
                this.enableResolveObject(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        protected final Class resolveClass(java.io.ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            return ChunkedObjectInputStream.this.resolveClass(objectStreamClass);
        }

        protected final Object resolveObject(Object object) throws IOException {
            return ChunkedObjectInputStream.this.resolveObject(object);
        }

        protected final java.io.ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            return ChunkedObjectInputStream.this.readClassDescriptor();
        }

        protected final void readStreamHeader() throws IOException {
        }

        public final Chunk readChunks() throws IOException {
            return ChunkedObjectInputStream.this.readChunks();
        }

        public final int readChunkLength() throws IOException {
            return ChunkedObjectInputStream.this.readInt();
        }

        public final int readByteArray(byte[] byArray, int n, int n2) throws IOException {
            return ChunkedObjectInputStream.this.read(byArray, n, n2);
        }

        public final String readASCII() throws IOException {
            return DataIO.readASCII(this);
        }

        public final String readUTF8() throws IOException {
            return DataIO.readUTF8(this);
        }

        public final Object readObject(Class clazz) throws IOException, ClassNotFoundException {
            return this.readObject();
        }
    }

    private static final class ExternalizableInfo {
        final int endEnvelope;
        final String name;

        ExternalizableInfo(int n, String string) {
            this.endEnvelope = n;
            this.name = string;
        }
    }
}

