/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import sun.misc.Unsafe;
import sun.reflect.ReflectionFactory;
import weblogic.utils.collections.WeakConcurrentHashMap;
import weblogic.utils.io.ObjectInput;
import weblogic.utils.io.ObjectOutput;
import weblogic.utils.io.ObjectStreamField;

public final class ObjectStreamClass {
    private static final Class[] NO_ARGS_METHOD = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];
    private static final Class[] WRITE_OBJECT_ARGS = new Class[]{ObjectOutputStream.class};
    private static final Class[] READ_OBJECT_ARGS = new Class[]{ObjectInputStream.class};
    private static final String READ_RESOLVE_METHOD = "readResolve";
    private static final String WRITE_REPLACE_METHOD = "writeReplace";
    private static final String READ_OBJECT_METHOD = "readObject";
    private static final String WRITE_OBJECT_METHOD = "writeObject";
    private static final boolean DEBUG = false;
    private static final Method GET_FIELD_METHOD = ObjectStreamClass.getDeclaredMethod(java.io.ObjectStreamField.class, "getField", NO_ARGS_METHOD);
    private static final Method GET_SIGNATURE_METHOD = ObjectStreamClass.getDeclaredMethod(java.io.ObjectStreamField.class, "getSignature", NO_ARGS_METHOD);
    private static final ReflectionFactory FACTORY = ObjectStreamClass.getReflectionFactory();
    private static final Unsafe UNSAFE = ObjectStreamClass.getUnsafe();
    private static final WeakConcurrentHashMap CACHE = new WeakConcurrentHashMap();
    private final Class theClass;
    private final Method readResolveMethod;
    private final Method writeReplaceMethod;
    private final Method readObjectMethod;
    private final Method writeObjectMethod;
    private final java.io.ObjectStreamClass osc;
    private final Constructor constructor;
    private final boolean customMarshaled;
    private final boolean externalizable;
    private final boolean array;
    private final ObjectStreamField[] serialFields;
    private ObjectStreamClass superclass;

    private ObjectStreamClass(Class clazz) {
        GenericDeclaration genericDeclaration;
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (!Serializable.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must implement Serializable");
        }
        this.theClass = clazz;
        this.osc = java.io.ObjectStreamClass.lookup(this.theClass);
        this.writeObjectMethod = ObjectStreamClass.getDeclaredMethod(this.theClass, WRITE_OBJECT_METHOD, WRITE_OBJECT_ARGS);
        this.readObjectMethod = ObjectStreamClass.getDeclaredMethod(this.theClass, READ_OBJECT_METHOD, READ_OBJECT_ARGS);
        this.customMarshaled = this.getCustomMarshaled();
        this.array = this.theClass.isArray();
        this.externalizable = Externalizable.class.isAssignableFrom(this.theClass);
        if (this.externalizable) {
            this.constructor = ObjectStreamClass.getPrivateConstructor(this.theClass);
            this.serialFields = null;
        } else {
            this.constructor = ObjectStreamClass.getSerializationConstructor(this.theClass);
            this.serialFields = ObjectStreamClass.getSerialFields(this.osc);
        }
        if (!this.theClass.isArray() && (genericDeclaration = this.theClass.getSuperclass()) != null && genericDeclaration.getSuperclass() != null && Serializable.class.isAssignableFrom((Class<?>)genericDeclaration)) {
            this.superclass = ObjectStreamClass.lookup(genericDeclaration);
        }
        genericDeclaration = null;
        genericDeclaration = ObjectStreamClass.getDeclaredMethod(this.theClass, READ_RESOLVE_METHOD, NO_ARGS_METHOD);
        this.readResolveMethod = genericDeclaration == null && this.superclass != null ? this.superclass.readResolveMethod : genericDeclaration;
        genericDeclaration = ObjectStreamClass.getDeclaredMethod(this.theClass, WRITE_REPLACE_METHOD, NO_ARGS_METHOD);
        this.writeReplaceMethod = genericDeclaration == null && this.superclass != null ? this.superclass.writeReplaceMethod : genericDeclaration;
    }

    public static boolean supportsUnsafeSerialization() {
        return UNSAFE != null;
    }

    public Class forClass() {
        return this.theClass;
    }

    public java.io.ObjectStreamClass getObjectStreamClass() {
        return this.osc;
    }

    public ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    public Object newInstance() throws IOException {
        try {
            if (this.constructor != null) {
                return this.constructor.newInstance(NO_ARGS);
            }
            if (this.externalizable) {
                return this.theClass.newInstance();
            }
            throw new NotSerializableException("Externalizables must have a public no-arg constructor, Serializables must have a public or protected no-arg constructor in a non-Serializable base-class");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (IOException)new NotSerializableException("Failed to construct " + this.forClass().getName()).initCause(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof IOException) {
                throw (IOException)invocationTargetException.getTargetException();
            }
            throw (IOException)new NotSerializableException("Failed to construct " + this.forClass().getName()).initCause(invocationTargetException.getTargetException());
        }
        catch (InstantiationException instantiationException) {
            throw (IOException)new NotSerializableException("Failed to construct " + this.forClass().getName()).initCause(instantiationException);
        }
    }

    public boolean hasWriteReplace() {
        return this.writeReplaceMethod != null;
    }

    public Object writeReplace(Object object) throws IOException {
        if (this.writeReplaceMethod == null) {
            return object;
        }
        try {
            return this.writeReplaceMethod.invoke(object, NO_ARGS);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (IOException)new IOException("Failed to invoke writeReplace() on " + this.forClass().getName()).initCause(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof IOException) {
                throw (IOException)invocationTargetException.getTargetException();
            }
            throw (IOException)new IOException("Failed to invoke writeReplace() on " + this.forClass().getName()).initCause(invocationTargetException.getTargetException());
        }
    }

    public Object readResolve(Object object) throws IOException {
        if (this.readResolveMethod == null) {
            return object;
        }
        try {
            return this.readResolveMethod.invoke(object, NO_ARGS);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (IOException)new IOException("Failed to invoke readResolve() on " + this.forClass().getName()).initCause(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof IOException) {
                throw (IOException)invocationTargetException.getTargetException();
            }
            throw (IOException)new IOException("Failed to invoke readResolve() on " + this.forClass().getName()).initCause(invocationTargetException.getTargetException());
        }
    }

    public boolean hasWriteObject() {
        return this.writeObjectMethod != null;
    }

    public void writeObject(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        if (this.writeObjectMethod == null) {
            throw new IOException("No writeObject method for: " + object);
        }
        try {
            this.writeObjectMethod.invoke(object, objectOutputStream);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (IOException)new IOException("Failed to invoke writeObject() on " + this.forClass().getName()).initCause(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof IOException) {
                throw (IOException)invocationTargetException.getTargetException();
            }
            throw (IOException)new IOException("Failed to invoke writeObject() on " + this.forClass().getName()).initCause(invocationTargetException.getTargetException());
        }
    }

    public boolean hasReadObject() {
        return this.readObjectMethod != null;
    }

    public void readObject(Object object, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.readObjectMethod == null) {
            throw new IOException("No readObject() method for: " + object);
        }
        try {
            this.readObjectMethod.invoke(object, objectInputStream);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw (IOException)new IOException("Failed to invoke readObject() on " + this.forClass().getName()).initCause(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)invocationTargetException.getTargetException();
            }
            if (invocationTargetException.getTargetException() instanceof IOException) {
                throw (IOException)invocationTargetException.getTargetException();
            }
            throw (IOException)new IOException("Failed to invoke readObject() on " + this.forClass().getName()).initCause(invocationTargetException.getTargetException());
        }
    }

    public boolean isCustomMarshaled() {
        return this.customMarshaled;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)object;
            return objectStreamClass.osc.equals(this.osc);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.osc.hashCode();
    }

    public String toString() {
        return this.osc.toString();
    }

    public long getSerialVersionUID() {
        return this.osc.getSerialVersionUID();
    }

    public ObjectStreamField[] getFields() {
        return this.serialFields;
    }

    public void writeFields(Object object, ObjectOutput objectOutput) throws IOException {
        block11: for (int i = 0; i < this.serialFields.length; ++i) {
            ObjectStreamField objectStreamField = this.serialFields[i];
            switch (objectStreamField.getTypeCode()) {
                case 'Z': {
                    objectOutput.writeBoolean(UNSAFE.getBoolean(object, objectStreamField.getFieldOffset()));
                    continue block11;
                }
                case 'B': {
                    objectOutput.writeByte(UNSAFE.getByte(object, objectStreamField.getFieldOffset()));
                    continue block11;
                }
                case 'C': {
                    objectOutput.writeChar(UNSAFE.getChar(object, objectStreamField.getFieldOffset()));
                    continue block11;
                }
                case 'S': {
                    objectOutput.writeShort(UNSAFE.getShort(object, objectStreamField.getFieldOffset()));
                    continue block11;
                }
                case 'I': {
                    objectOutput.writeInt(UNSAFE.getInt(object, objectStreamField.getFieldOffset()));
                    continue block11;
                }
                case 'F': {
                    objectOutput.writeFloat(UNSAFE.getFloat(object, objectStreamField.getFieldOffset()));
                    continue block11;
                }
                case 'J': {
                    objectOutput.writeLong(UNSAFE.getLong(object, objectStreamField.getFieldOffset()));
                    continue block11;
                }
                case 'D': {
                    objectOutput.writeDouble(UNSAFE.getDouble(object, objectStreamField.getFieldOffset()));
                    continue block11;
                }
                case 'L': 
                case '[': {
                    objectOutput.writeObject(UNSAFE.getObject(object, objectStreamField.getFieldOffset()), objectStreamField.getType());
                    continue block11;
                }
                default: {
                    throw new IOException("Bad typecode: " + objectStreamField.getTypeCode());
                }
            }
        }
    }

    public void readFields(Object object, ObjectInput objectInput) throws IOException, ClassCastException, ClassNotFoundException {
        block11: for (int i = 0; i < this.serialFields.length; ++i) {
            ObjectStreamField objectStreamField = this.serialFields[i];
            switch (objectStreamField.getTypeCode()) {
                case 'Z': {
                    UNSAFE.putBoolean(object, objectStreamField.getFieldOffset(), objectInput.readBoolean());
                    continue block11;
                }
                case 'B': {
                    UNSAFE.putByte(object, objectStreamField.getFieldOffset(), objectInput.readByte());
                    continue block11;
                }
                case 'C': {
                    UNSAFE.putChar(object, objectStreamField.getFieldOffset(), objectInput.readChar());
                    continue block11;
                }
                case 'S': {
                    UNSAFE.putShort(object, objectStreamField.getFieldOffset(), objectInput.readShort());
                    continue block11;
                }
                case 'I': {
                    UNSAFE.putInt(object, objectStreamField.getFieldOffset(), objectInput.readInt());
                    continue block11;
                }
                case 'F': {
                    UNSAFE.putFloat(object, objectStreamField.getFieldOffset(), objectInput.readFloat());
                    continue block11;
                }
                case 'J': {
                    UNSAFE.putLong(object, objectStreamField.getFieldOffset(), objectInput.readLong());
                    continue block11;
                }
                case 'D': {
                    UNSAFE.putDouble(object, objectStreamField.getFieldOffset(), objectInput.readDouble());
                    continue block11;
                }
                case 'L': 
                case '[': {
                    Object object2 = objectInput.readObject(objectStreamField.getType());
                    if (object2 != null && !objectStreamField.getType().isInstance(object2)) {
                        throw new ClassCastException("Stream corrupted: expecting: " + objectStreamField.getType().getName() + ", received: " + object2.getClass().getName());
                    }
                    UNSAFE.putObject(object, objectStreamField.getFieldOffset(), object2);
                    continue block11;
                }
                default: {
                    throw new IOException("Bad typecode: " + objectStreamField.getTypeCode());
                }
            }
        }
    }

    public boolean isExternalizable() {
        return this.externalizable;
    }

    private boolean getCustomMarshaled() {
        Class clazz = this.theClass;
        boolean bl = false;
        if (Externalizable.class.isAssignableFrom(clazz) || this.writeObjectMethod != null) {
            bl = true;
        } else if (Serializable.class.isAssignableFrom(clazz)) {
            clazz = clazz.getSuperclass();
            while (!(clazz == null || clazz.isInterface() || clazz.isPrimitive() || clazz.isArray())) {
                try {
                    clazz.getDeclaredMethod(WRITE_OBJECT_METHOD, WRITE_OBJECT_ARGS);
                    bl = true;
                    clazz = null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    clazz = clazz.getSuperclass();
                }
            }
        }
        return bl;
    }

    private static Method getDeclaredMethod(Class clazz, String string, Class[] classArray) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            if (!method.isAccessible()) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    method = null;
                }
            }
            return method;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    private static Constructor getPrivateConstructor(Class clazz) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(NO_ARGS_METHOD);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
                return constructor;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Constructor getSerializationConstructor(Class clazz) {
        if (FACTORY == null || UNSAFE == null) {
            return null;
        }
        Class clazz2 = clazz;
        while (Serializable.class.isAssignableFrom(clazz2)) {
            if ((clazz2 = clazz2.getSuperclass()) != null) continue;
            return null;
        }
        try {
            Constructor<Object> constructor = clazz2.getDeclaredConstructor(NO_ARGS_METHOD);
            if (constructor == null) {
                return null;
            }
            if ((constructor.getModifiers() & 5) == 0) {
                Package package_;
                if ((constructor.getModifiers() & 2) != 0) {
                    return null;
                }
                Package package_2 = clazz.getPackage();
                if (!(package_2 == (package_ = clazz2.getPackage()) || package_2 != null && package_2.equals(package_))) {
                    return null;
                }
            }
            constructor = FACTORY.newConstructorForSerialization(clazz, constructor);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static final ObjectStreamClass lookup(Class clazz) {
        WeakReference weakReference = (WeakReference)CACHE.get(clazz);
        ObjectStreamClass objectStreamClass = null;
        if (weakReference != null) {
            objectStreamClass = (ObjectStreamClass)weakReference.get();
        }
        if (objectStreamClass == null) {
            if (!Serializable.class.isAssignableFrom(clazz)) {
                return null;
            }
            objectStreamClass = new ObjectStreamClass(clazz);
            CACHE.put(clazz, new WeakReference<ObjectStreamClass>(objectStreamClass));
        }
        return objectStreamClass;
    }

    private static ReflectionFactory getReflectionFactory() {
        try {
            return (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }

    private static Unsafe getUnsafe() {
        try {
            String string = System.getProperty("weblogic.system.useUnsafeSerialization");
            if (string != null && string.equalsIgnoreCase("false")) {
                return null;
            }
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return null;
        }
    }

    private static Field getField(java.io.ObjectStreamField objectStreamField) {
        try {
            return (Field)GET_FIELD_METHOD.invoke((Object)objectStreamField, NO_ARGS);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    private static String getSignature(java.io.ObjectStreamField objectStreamField) {
        try {
            return (String)GET_SIGNATURE_METHOD.invoke((Object)objectStreamField, NO_ARGS);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    private static ObjectStreamField[] getSerialFields(java.io.ObjectStreamClass objectStreamClass) {
        java.io.ObjectStreamField[] objectStreamFieldArray = objectStreamClass.getFields();
        ObjectStreamField[] objectStreamFieldArray2 = new ObjectStreamField[objectStreamFieldArray.length];
        for (int i = 0; i < objectStreamFieldArray.length; ++i) {
            Field field = ObjectStreamClass.getField(objectStreamFieldArray[i]);
            String string = ObjectStreamClass.getSignature(objectStreamFieldArray[i]);
            int n = -1;
            if (field != null && UNSAFE != null) {
                n = UNSAFE.fieldOffset(field);
            }
            objectStreamFieldArray2[i] = new ObjectStreamField(objectStreamFieldArray[i], n, string);
        }
        return objectStreamFieldArray2;
    }

    private static void p(String string) {
        System.out.println("<ObjectStreamClass>: " + string);
    }
}

