/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import weblogic.utils.collections.Iterators;
import weblogic.utils.enumerations.EmptyEnumerator;
import weblogic.utils.enumerations.FileEnumeration;
import weblogic.utils.jars.BaseExplodedJarFile;
import weblogic.utils.jars.VirtualJarFile;

final class ExplodedJarFile
extends BaseExplodedJarFile
implements VirtualJarFile {
    private final File directory;

    public ExplodedJarFile(File file) {
        this.directory = file;
    }

    public String getName() {
        return this.directory.toString();
    }

    public void close() {
    }

    public Iterator entries() {
        return this.getEntries(null);
    }

    public Iterator getEntries(String string) {
        File file = this.directory;
        if (string != null && !string.equals("/") && !(file = new File(this.directory, string.replace('/', File.separatorChar))).exists()) {
            return Iterators.EMPTY_ITERATOR;
        }
        final File file2 = file;
        return new Iterator(){
            private int dirLen;
            Enumeration e;
            {
                this.dirLen = ExplodedJarFile.this.directory.toString().length();
            }

            private void init() {
                if (this.e != null) {
                    return;
                }
                try {
                    this.e = new FileEnumeration(file2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.e = new EmptyEnumerator();
                }
            }

            public Object next() {
                this.init();
                String string = this.e.nextElement().toString();
                string = string.replace(File.separatorChar, '/').substring(this.dirLen + (string.length() == this.dirLen ? 0 : 1));
                return new BaseExplodedJarFile.VirtualJarEntry(ExplodedJarFile.this.directory, string);
            }

            public boolean hasNext() {
                this.init();
                return this.e.hasMoreElements();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ZipEntry getEntry(String string) {
        return this.getEntry(this.directory, string);
    }

    public File[] getRootFiles() {
        return new File[]{this.directory};
    }

    public File getDirectory() {
        return this.directory;
    }

    public String toString() {
        return "ExplodedJarFile{" + this.getName() + "}";
    }
}

