/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.jars;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import weblogic.utils.jars.ExplodedJarFile;
import weblogic.utils.jars.JarFileDelegate;
import weblogic.utils.jars.SplitExplodedJarFile;
import weblogic.utils.jars.VirtualJarFile;

public final class VirtualJarFactory {
    public static VirtualJarFile createVirtualJar(File[] fileArray) throws IOException {
        if (fileArray.length == 1) {
            return VirtualJarFactory.createVirtualJar(fileArray[0]);
        }
        return new SplitExplodedJarFile(fileArray);
    }

    public static VirtualJarFile createVirtualJar(File file) throws IOException {
        if (file.isDirectory()) {
            return new ExplodedJarFile(file);
        }
        return new JarFileDelegate(file);
    }

    public static VirtualJarFile createVirtualJar(File file, File file2) {
        return new SplitExplodedJarFile(file, file2);
    }

    public static VirtualJarFile createVirtualJar(JarFile jarFile) {
        return new JarFileDelegate(jarFile);
    }
}

