/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.net;

import java.util.StringTokenizer;

public class InetAddressHelper {
    public static boolean isIPV6Address(String string) {
        int n = -1;
        if (string == null || (n = string.indexOf("@")) != -1 && string.lastIndexOf(":") > n || string.indexOf("[") != -1 || string.startsWith("file:")) {
            return false;
        }
        if (string.indexOf("::") != -1) {
            return true;
        }
        if (string.indexOf(".") == -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            return stringTokenizer.countTokens() > 3;
        }
        return false;
    }

    public static String convertToIPV6URL(String string) {
        if (string.indexOf("[") != -1 || string.indexOf("localhost") != -1 || string.indexOf(":") == -1) {
            return string;
        }
        if (string.indexOf("corbaloc") != -1) {
            return InetAddressHelper.convertCorbaURL(string);
        }
        int n = -1;
        n = string.indexOf("://");
        if (n == -1) {
            return InetAddressHelper.convertHostPortURL(string);
        }
        return InetAddressHelper.convertProtocolHostPortURL(string, n);
    }

    public static String convertIfIPV6URL(String string) {
        if (InetAddressHelper.isIPV6Address(string)) {
            return InetAddressHelper.convertToIPV6URL(string);
        }
        return string;
    }

    public static String convertHostIfIPV6(String string) {
        if (InetAddressHelper.isIPV6Address(string) && string.indexOf("[") == -1) {
            return "[" + string + "]";
        }
        return string;
    }

    private static String convertHostPortURL(String string) {
        int n = string.lastIndexOf(":");
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf("/");
        if (n2 == -1 || n2 < n) {
            n2 = string.length();
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n, n2);
        String string4 = "";
        if (n2 < string.length()) {
            string4 = string.substring(n2, string.length());
        }
        return "[" + string2 + "]" + string3 + string4;
    }

    private static String convertProtocolHostPortURL(String string, int n) {
        int n2 = string.lastIndexOf(":");
        if (n2 <= n) {
            return string;
        }
        int n3 = string.lastIndexOf("/");
        String string2 = "";
        if (n3 > n + 3) {
            string2 = string.substring(n3);
        } else {
            n3 = string.length();
        }
        String string3 = string.substring(n + 3, n2);
        String string4 = string.substring(0, n + 3);
        String string5 = string.substring(n2, n3);
        return string4 + "[" + string3 + "]" + string5 + string2;
    }

    private static String convertCorbaURL(String string) {
        int n = string.indexOf("iiop");
        int n2 = string.indexOf(":", n + 1);
        int n3 = string.lastIndexOf(":");
        String string2 = string.substring(0, n2 + 1);
        String string3 = string.substring(n2 + 1, n3);
        String string4 = string.substring(n3);
        return string2 + "[" + string3 + "]" + string4;
    }
}

