/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.string;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.utils.string.SimpleCachingDateFormat;
import weblogic.utils.string.ThreadLocalDateFormat;

public abstract class CachingDateFormat {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    protected static final String RFC1123DatePattern = "EE, dd MMM yyyy HH:mm:ss zz";
    protected static final String RFC850DatePattern = "EEEE, dd-MMM-yy HH:mm:ss zz";
    protected static final String ASCTimeDatePattern = "EE MMM  d HH:mm:ss yyyy";
    private static final CachingDateFormat RFC1123Format = new SimpleCachingDateFormat("EE, dd MMM yyyy HH:mm:ss zz", GMT);
    private static final CachingDateFormat RFC850Format = new SimpleCachingDateFormat("EEEE, dd-MMM-yy HH:mm:ss zz", GMT);
    private static final CachingDateFormat ASCTimeFormat = new SimpleCachingDateFormat("EE MMM  d HH:mm:ss yyyy", GMT);
    protected int resolution;
    private long expiration;
    private String formatString;

    public static String getRFC1123Date() {
        return CachingDateFormat.getRFC1123Date(System.currentTimeMillis());
    }

    public static String getRFC1123Date(long l) {
        return RFC1123Format.getDate(l);
    }

    public static String getRFC850Date() {
        return CachingDateFormat.getRFC850Date(System.currentTimeMillis());
    }

    public static String getRFC850Date(long l) {
        return RFC850Format.getDate(l);
    }

    public static String getASCTimeDate() {
        return CachingDateFormat.getASCTimeDate(System.currentTimeMillis());
    }

    public static String getASCTimeDate(long l) {
        return ASCTimeFormat.getDate(l);
    }

    public static long parseDate(String string, DateFormat[] dateFormatArray) {
        Long l = (Long)ParseCacheHolder.CACHE.get(string);
        if (l != null) {
            return l;
        }
        Long l2 = null;
        l2 = dateFormatArray != null ? CachingDateFormat.internalParseDate(string, dateFormatArray) : CachingDateFormat.internalParseDate(string, ThreadLocalDateFormat.getInstance().getDateFormats());
        CachingDateFormat.updateParseCache(string, l2);
        if (l2 == null) {
            return -1L;
        }
        return l2;
    }

    public final String getDate() {
        return this.getDate(System.currentTimeMillis());
    }

    public final String getDate(long l) {
        if (l > this.expiration || l + (long)this.resolution <= this.expiration) {
            this.formatString = this.format(l);
            this.expiration = l + ((long)this.resolution - l % (long)this.resolution);
        }
        return this.formatString;
    }

    protected abstract String format(long var1);

    private static Long internalParseDate(String string, DateFormat[] dateFormatArray) {
        Date date = null;
        for (int i = 0; date == null && i < dateFormatArray.length; ++i) {
            try {
                date = dateFormatArray[i].parse(string);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            return null;
        }
        return new Long(date.getTime());
    }

    private static void updateParseCache(String string, Long l) {
        if (l == null) {
            return;
        }
        if (ParseCacheHolder.CACHE.size() > ParseCacheHolder.CACHE_SIZE) {
            ParseCacheHolder.CACHE.clear();
        }
        ParseCacheHolder.CACHE.put(string, l);
    }

    private static class ParseCacheHolder {
        private static final int CACHE_SIZE = Integer.getInteger("weblogic.utils.cachingdateformat.cachesize", 600);
        private static final ConcurrentHashMap CACHE = new ConcurrentHashMap(CACHE_SIZE);

        private ParseCacheHolder() {
        }
    }
}

