/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.string;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import weblogic.utils.string.SimpleCachingDateFormat;

public class ThreadLocalDateFormat
extends SimpleCachingDateFormat {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    protected SimpleDateFormat[] formats = null;
    private static final ThreadLocal tl = new ThreadLocal(){

        protected Object initialValue() {
            return new ThreadLocalDateFormat();
        }
    };

    private ThreadLocalDateFormat() {
        super("EEE, dd MMM yyyy HH:mm:ss zz", GMT, Locale.ENGLISH);
    }

    public static ThreadLocalDateFormat getInstance() {
        return (ThreadLocalDateFormat)tl.get();
    }

    public DateFormat[] getDateFormats() {
        if (this.formats != null) {
            return this.formats;
        }
        this.formats = new SimpleDateFormat[]{new SimpleDateFormat("EE, dd MMM yyyy HH:mm:ss zz", Locale.US), new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss zz", Locale.US), new SimpleDateFormat("EE MMM  d HH:mm:ss yyyy", Locale.US)};
        for (int i = 0; i < this.formats.length; ++i) {
            this.formats[i].setTimeZone(GMT);
        }
        return this.formats;
    }
}

