/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security;

import com.bea.common.logger.spi.LoggableMessageSpi;
import com.bea.common.logger.spi.LoggerSpi;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class ApiLogger {
    private static final String PROPERTIES_PREFIX = "BEA";
    private static final String PROPERTIES_SUBSYSTEM = "Security";
    private static final String PROPERTIES_NAME = "ApiLogger";
    private static final String PROPERTIES_EXT = ".properties";
    private static final String MESSAGEBODY_PRE = "messagebody";
    private static final String SEVERITY_PRE = "severity";
    private static final String PREFIX_PRE = "[Security:";
    private static final String PREFIX_POST = "]";
    private static PropertyResourceBundle theBundle = null;

    private static String escape(String message) {
        if (message == null) {
            return null;
        }
        int index = -1;
        int len = message.length();
        for (int i = 0; i < len; ++i) {
            char c = message.charAt(i);
            if (c != '$' && c != '\\') continue;
            index = i;
            break;
        }
        if (index == -1) {
            return message;
        }
        StringBuffer buffer = new StringBuffer(len + len - index);
        if (index != 0) {
            buffer.append(message.substring(0, index));
        }
        buffer.append('\\').append(message.charAt(index));
        for (int i = index + 1; i < len; ++i) {
            char c = message.charAt(i);
            if (c == '$' || c == '\\') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static String formatMessage(String messageIn, Object[] args) {
        if (args == null || args.length == 0 || messageIn == null) {
            return messageIn;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            messageIn = messageIn.replaceAll("\\x7B" + i + "\\x7D", ApiLogger.escape(args[i].toString()));
        }
        return messageIn;
    }

    private static String getMessageBody(String messageId) {
        ResourceBundle bundle = ApiLogger.getResourceBundle();
        if (bundle == null) {
            return messageId;
        }
        String theMessage = null;
        try {
            theMessage = bundle.getString(MESSAGEBODY_PRE + messageId);
        }
        catch (MissingResourceException mre) {
            theMessage = messageId;
        }
        return theMessage;
    }

    private static synchronized ResourceBundle getResourceBundle() {
        if (theBundle != null) {
            return theBundle;
        }
        Locale defLocale = Locale.getDefault();
        String[] bundleNames = new String[]{"ApiLogger_" + defLocale.getLanguage() + "_" + defLocale.getCountry() + "_" + defLocale.getVariant() + PROPERTIES_EXT, "ApiLogger_" + defLocale.getLanguage() + "_" + defLocale.getCountry() + PROPERTIES_EXT, "ApiLogger_" + defLocale.getLanguage() + PROPERTIES_EXT, "ApiLogger.properties"};
        InputStream theBundleStream = null;
        ClassLoader theLoader = ApiLogger.class.getClassLoader();
        for (int i = 0; theBundleStream == null && i < bundleNames.length; ++i) {
            theBundleStream = theLoader.getResourceAsStream(bundleNames[i]);
        }
        if (theBundleStream == null) {
            return null;
        }
        try {
            theBundle = new PropertyResourceBundle(theBundleStream);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return theBundle;
    }

    private static void logMessage(LoggerSpi logger, String severity, LoggableMessageSpiImpl message) {
        if (severity.equals("info")) {
            logger.info((Object)message);
        } else if (severity.equals("warning")) {
            logger.warn((Object)message);
        } else if (severity.equals("error")) {
            logger.error((Object)message);
        } else if (severity.equals("alert") || severity.equals("severe")) {
            logger.severe((Object)message);
        }
    }

    public static String getDecimalIsTooShort() {
        Object[] args = new Object[]{};
        String messageId = "098500";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDecimalIsTooShortLoggable() {
        Object[] args = new Object[]{};
        String messageId = "098500";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getDecimalIncorrectCharacters() {
        Object[] args = new Object[]{};
        String messageId = "098501";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getDecimalIncorrectCharactersLoggable() {
        Object[] args = new Object[]{};
        String messageId = "098501";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getHexBinaryBadLength() {
        Object[] args = new Object[]{};
        String messageId = "098502";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getHexBinaryBadLengthLoggable() {
        Object[] args = new Object[]{};
        String messageId = "098502";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidHexDigit() {
        Object[] args = new Object[]{};
        String messageId = "098503";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidHexDigitLoggable() {
        Object[] args = new Object[]{};
        String messageId = "098503";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getInvalidRFC822Name(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098504";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getInvalidRFC822NameLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098504";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getIllegalX500Value(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098505";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIllegalX500ValueLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098505";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getNotEnoughBASE64Bytes() {
        Object[] args = new Object[]{};
        String messageId = "098506";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNotEnoughBASE64BytesLoggable() {
        Object[] args = new Object[]{};
        String messageId = "098506";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getIncorrectXPathVersion() {
        Object[] args = new Object[]{};
        String messageId = "098507";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIncorrectXPathVersionLoggable() {
        Object[] args = new Object[]{};
        String messageId = "098507";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getNegativeMonthNonZeroYear() {
        Object[] args = new Object[]{};
        String messageId = "098508";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getNegativeMonthNonZeroYearLoggable() {
        Object[] args = new Object[]{};
        String messageId = "098508";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getMonthOrYearBothZero() {
        Object[] args = new Object[]{};
        String messageId = "098509";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMonthOrYearBothZeroLoggable() {
        Object[] args = new Object[]{};
        String messageId = "098509";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getMethodInternalError(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098510";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getMethodInternalErrorLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098510";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getIllegalTimeZoneComparison() {
        Object[] args = new Object[]{};
        String messageId = "098511";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIllegalTimeZoneComparisonLoggable() {
        Object[] args = new Object[]{};
        String messageId = "098511";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getAuditLogTriggerError() {
        Object[] args = new Object[]{};
        String messageId = "098512";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getAuditLogTriggerErrorLoggable() {
        Object[] args = new Object[]{};
        String messageId = "098512";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static void logServiceInitializationException(LoggerSpi logger, String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098513";
        LoggableMessageSpiImpl loggable = new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
        ApiLogger.logMessage(logger, "error", loggable);
    }

    public static LoggableMessageSpi logServiceInitializationExceptionLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098513";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getFailedToGenerateThumbprint(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098514";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getFailedToGenerateThumbprintLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098514";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getIllegalArgumentSpecified(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "098515";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getIllegalArgumentSpecifiedLoggable(String arg0, String arg1, String arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        String messageId = "098515";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getCertificateRegistryBuildFailureUnregisteredThumbprint(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098516";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getCertificateRegistryBuildFailureUnregisteredThumbprintLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098516";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    public static String getFailedToGetSAMLAssertionInfo(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098517";
        String msg = PREFIX_PRE + messageId + PREFIX_POST + ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args);
        return msg;
    }

    public static LoggableMessageSpi getFailedToGetSAMLAssertionInfoLoggable(String arg0) {
        Object[] args = new Object[]{arg0};
        String messageId = "098517";
        return new LoggableMessageSpiImpl(messageId, ApiLogger.formatMessage(ApiLogger.getMessageBody(messageId), args));
    }

    private static class LoggableMessageSpiImpl
    implements LoggableMessageSpi {
        private String messageId = null;
        private String formattedMessageBody = null;

        LoggableMessageSpiImpl(String messageId, String formattedMessageBody) {
            this.messageId = messageId;
            this.formattedMessageBody = formattedMessageBody;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public String getPrefix() {
            return ApiLogger.PROPERTIES_PREFIX;
        }

        public String getSubsystem() {
            return ApiLogger.PROPERTIES_SUBSYSTEM;
        }

        public String getFormattedMessageBody() {
            return this.formattedMessageBody;
        }

        public String toString() {
            return ApiLogger.PREFIX_PRE + this.messageId + ApiLogger.PREFIX_POST + this.formattedMessageBody;
        }
    }
}

