/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.store.data;

import com.bea.common.security.store.data.ApplicationIdUtil;
import com.bea.common.security.store.data.Credential;
import com.bea.common.security.store.data.DomainRealmScopeId;
import com.bea.common.security.utils.Pair;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CredentialId
extends DomainRealmScopeId {
    public static final String CREDENTIALNAME = "credentialName";
    private String credentialName;

    public CredentialId() {
    }

    public CredentialId(String domainName, String realmName, String credentialName) {
        super(domainName, realmName);
        this.credentialName = credentialName;
    }

    public CredentialId(String binding) {
        super(binding);
        Map<String, String> p = ApplicationIdUtil.parse(binding);
        this.credentialName = p.get(CREDENTIALNAME);
    }

    public CredentialId(Credential obj) {
        super(obj);
        this.credentialName = obj.getCredentialName();
    }

    @Override
    protected Pair<String, Map<String, Object>> prepareQuery() {
        Pair<String, Map<String, Object>> p = super.prepareQuery();
        Map params = (Map)p.getRight();
        params.put(CREDENTIALNAME, this.credentialName);
        StringBuffer filter = new StringBuffer();
        filter.append((String)p.getLeft());
        filter.append(" && this.credentialName == credentialName");
        return new Pair((Object)filter.toString(), (Object)params);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof CredentialId)) {
            return false;
        }
        CredentialId o = (CredentialId)other;
        return this.credentialName == o.credentialName || this.credentialName != null && this.credentialName.equals(o.credentialName);
    }

    @Override
    public int hashCode() {
        return (this.credentialName != null ? this.credentialName.hashCode() : 0) ^ super.hashCode();
    }

    @Override
    public String toString() {
        return new StringBuffer().append("credentialName=").append(ApplicationIdUtil.encode(this.credentialName)).append(',').append(super.toString()).toString();
    }

    public String getCredentialName() {
        return this.credentialName;
    }

    public void setCredentialName(String credentialName) {
        this.credentialName = credentialName;
    }
}

