/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.store.data;

import com.bea.common.security.store.data.ApplicationIdUtil;
import com.bea.common.security.store.data.CredentialMap;
import com.bea.common.security.store.data.DomainRealmScopeId;
import com.bea.common.security.utils.Pair;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CredentialMapId
extends DomainRealmScopeId {
    public static final String CN = "cn";
    private String cn;

    public CredentialMapId() {
    }

    public CredentialMapId(String domainName, String realmName, String cn) {
        super(domainName, realmName);
        this.cn = cn;
    }

    public CredentialMapId(String binding) {
        super(binding);
        Map<String, String> p = ApplicationIdUtil.parse(binding);
        this.cn = p.get(CN);
    }

    public CredentialMapId(CredentialMap obj) {
        super(obj);
        this.cn = obj.getCn();
    }

    @Override
    protected Pair<String, Map<String, Object>> prepareQuery() {
        Pair<String, Map<String, Object>> p = super.prepareQuery();
        Map params = (Map)p.getRight();
        params.put(CN, this.cn);
        StringBuffer filter = new StringBuffer();
        filter.append((String)p.getLeft());
        filter.append(" && this.cn == cn");
        return new Pair((Object)filter.toString(), (Object)params);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof CredentialMapId)) {
            return false;
        }
        CredentialMapId o = (CredentialMapId)other;
        return this.cn == o.cn || this.cn != null && this.cn.equals(o.cn);
    }

    @Override
    public int hashCode() {
        return (this.cn != null ? this.cn.hashCode() : 0) ^ super.hashCode();
    }

    @Override
    public String toString() {
        return new StringBuffer().append("cn=").append(ApplicationIdUtil.encode(this.cn)).append(',').append(super.toString()).toString();
    }

    public String getCn() {
        return this.cn;
    }

    public void setCn(String cn) {
        this.cn = cn;
    }
}

