/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.store.data;

import com.bea.common.security.store.data.ApplicationIdUtil;
import com.bea.common.security.store.data.DomainRealmScopeId;
import com.bea.common.security.store.data.PKITypeScope;
import com.bea.common.security.utils.Pair;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PKITypeScopeId
extends DomainRealmScopeId {
    public static final String TYPENAME = "typeName";
    private String typeName;

    public PKITypeScopeId() {
    }

    public PKITypeScopeId(String domainName, String realmName, String typeName) {
        super(domainName, realmName);
        this.typeName = typeName;
    }

    public PKITypeScopeId(String binding) {
        super(binding);
        Map<String, String> p = ApplicationIdUtil.parse(binding);
        this.typeName = p.get(TYPENAME);
    }

    public PKITypeScopeId(PKITypeScope obj) {
        super(obj);
        this.typeName = obj.getTypeName();
    }

    @Override
    protected Pair<String, Map<String, Object>> prepareQuery() {
        Pair<String, Map<String, Object>> p = super.prepareQuery();
        Map params = (Map)p.getRight();
        params.put(TYPENAME, this.typeName);
        StringBuffer filter = new StringBuffer();
        filter.append((String)p.getLeft());
        filter.append(" && this.typeName == typeName");
        return new Pair((Object)filter.toString(), (Object)params);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof PKITypeScopeId)) {
            return false;
        }
        PKITypeScopeId o = (PKITypeScopeId)other;
        return this.typeName == o.typeName || this.typeName != null && this.typeName.equals(o.typeName);
    }

    @Override
    public int hashCode() {
        return (this.typeName != null ? this.typeName.hashCode() : 0) ^ super.hashCode();
    }

    @Override
    public String toString() {
        return new StringBuffer().append("typeName=").append(ApplicationIdUtil.encode(this.typeName)).append(',').append(super.toString()).toString();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}

