/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaObject
implements Serializable {
    private transient int hash = 0;

    public void encode(OutputStream out) {
        this.encode(new HashMap<String, String>(), out);
    }

    public void encode(Map<String, String> nsMap, OutputStream out) {
        String prefix;
        boolean writeNS;
        boolean topLevel = nsMap.isEmpty();
        String ns = this.getNamespace();
        boolean bl = writeNS = !nsMap.containsKey(ns);
        if (writeNS) {
            prefix = topLevel ? null : this.getDesiredNamespacePrefix();
            nsMap.put(ns, prefix);
        } else {
            prefix = nsMap.get(ns);
        }
        PrintStream ps = this.getPrintStream(out);
        if (topLevel) {
            ps.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            ps.println();
        }
        ps.print('<');
        if (prefix != null) {
            ps.print(prefix);
            ps.print(':');
        }
        ps.print(this.getElementName());
        if (writeNS) {
            ps.print(" xmlns");
            if (prefix != null) {
                ps.print(':');
                ps.print(prefix);
            }
            ps.print("=\"");
            ps.print(ns);
            ps.print('\"');
        }
        this.encodeAttributes(ps);
        if (this.hasChildren() || this.hasBody()) {
            ps.print('>');
            if (this.hasChildren()) {
                this.encodeChildren(nsMap, ps);
            }
            if (this.hasBody()) {
                this.encodeBody(ps);
            }
            ps.print("</");
            if (prefix != null) {
                ps.print(prefix);
                ps.print(':');
            }
            ps.print(this.getElementName());
            ps.print('>');
        } else {
            ps.print("/>");
        }
        if (topLevel) {
            ps.flush();
        }
    }

    public abstract String getElementName();

    public void encodeAttributes(PrintStream ps) {
    }

    public boolean hasChildren() {
        return false;
    }

    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
    }

    public boolean hasBody() {
        return false;
    }

    public void encodeBody(PrintStream ps) {
    }

    public abstract String getNamespace();

    public abstract String getDesiredNamespacePrefix();

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.internalHashCode();
        }
        return this.hash;
    }

    public abstract int internalHashCode();

    protected PrintStream getPrintStream(OutputStream out) {
        if (out instanceof PrintStream) {
            return (PrintStream)out;
        }
        try {
            out = new PrintStream(out, false, "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            out = new PrintStream(out);
        }
        return (PrintStream)out;
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.encode(os);
        try {
            return new String(os.toByteArray(), "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            return new String(os.toByteArray());
        }
    }

    protected String getLocalName(Node node) {
        int idx;
        String name = node.getLocalName();
        if (name == null && (name = node.getNodeName()) != null && (idx = name.indexOf(58)) >= 0) {
            return name.substring(idx + 1);
        }
        return name;
    }
}

