/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeFactory;
import com.bea.common.security.xacml.attr.AttributeValue;
import com.bea.common.security.xacml.attr.StandardAttributes;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Node;

public class AttributeRegistry {
    private List<AttributeFactory> factories = Collections.synchronizedList(new ArrayList());

    public AttributeRegistry() throws URISyntaxException {
        this.register(new StandardAttributes());
    }

    public void register(AttributeFactory factory) {
        this.factories.add(factory);
    }

    public AttributeValue getAttribute(Node attribute) throws URISyntaxException, InvalidAttributeException {
        AttributeValue av = null;
        ListIterator<AttributeFactory> facIt = this.factories.listIterator();
        while (facIt.hasNext()) {
            av = facIt.next().createAttribute(attribute, this.factories.listIterator(facIt.nextIndex()));
            if (av == null) continue;
            return av;
        }
        throw new InvalidAttributeException("No configured factory for attribute value node: " + attribute.toString());
    }

    public AttributeValue getAttribute(URI dataType, Node attribute) throws URISyntaxException, InvalidAttributeException {
        AttributeValue av = null;
        ListIterator<AttributeFactory> facIt = this.factories.listIterator();
        while (facIt.hasNext()) {
            av = facIt.next().createAttribute(dataType, attribute, this.factories.listIterator(facIt.nextIndex()));
            if (av == null) continue;
            return av;
        }
        throw new InvalidAttributeException("No configured factory for attribute value node: " + attribute.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributeRegistry)) {
            return false;
        }
        return CollectionUtil.equals(this.factories, ((AttributeRegistry)o).factories);
    }

    public int hashCode() {
        return ((Object)this.factories).hashCode();
    }
}

