/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.jdkutils.WeaverUtil;
import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import com.bea.common.security.xacml.attr.ByteArrayHolder;
import com.bea.common.security.xacml.attr.encoders.BASE64Decoder;
import com.bea.common.security.xacml.attr.encoders.BASE64Encoder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Base64BinaryAttribute
extends AttributeValue<Base64BinaryAttribute> {
    private static BASE64Encoder b64Encoder = new BASE64Encoder();
    private static BASE64Decoder b64Decoder = new BASE64Decoder();
    private byte[] value;

    public Base64BinaryAttribute(byte[] value) {
        this.value = value;
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.BASE64_BINARY;
    }

    public Base64BinaryAttribute(String value) throws InvalidAttributeException {
        this(Base64BinaryAttribute.decode(value));
    }

    private static byte[] decode(String value) throws InvalidAttributeException {
        try {
            return b64Decoder.decodeBuffer(value);
        }
        catch (IOException io) {
            throw new InvalidAttributeException(io);
        }
    }

    @Override
    public ByteArrayHolder getValue() {
        return new ByteArrayHolder(this.value){

            public String toString() {
                return Base64BinaryAttribute.access$000().encodeBuffer(this.getData());
            }
        };
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(b64Encoder.encodeBuffer(this.value));
    }

    @Override
    public String toString() {
        return b64Encoder.encodeBuffer(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Base64BinaryAttribute)) {
            return false;
        }
        Base64BinaryAttribute other = (Base64BinaryAttribute)o;
        return Arrays.equals(this.value, other.value);
    }

    @Override
    public int internalHashCode() {
        return WeaverUtil.Arrays.hashCode((byte[])this.value);
    }

    @Override
    public int compareTo(Base64BinaryAttribute other) {
        int l = this.value.length;
        int lo = other.value.length;
        int i = 0;
        int j = 0;
        while (i < l) {
            if (j < lo) {
                if (this.value[i] != other.value[j]) {
                    return this.value[i] - other.value[j];
                }
            } else {
                return Math.abs(this.value[i]);
            }
            ++i;
            ++j;
        }
        if (j >= lo) {
            return 0;
        }
        return Math.abs(other.value[j]) * -1;
    }

    @Override
    public boolean add(Base64BinaryAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Base64BinaryAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Base64BinaryAttribute> iterator() {
        return new Iterator<Base64BinaryAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public Base64BinaryAttribute next() {
                this.nextNotCalled = false;
                return Base64BinaryAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((Base64BinaryAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((Base64BinaryAttribute)x0);
    }

    static BASE64Encoder access$000() {
        return b64Encoder;
    }
}

