/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CharacterAttribute
extends AttributeValue<CharacterAttribute> {
    private Character value;

    public CharacterAttribute(String value) throws InvalidAttributeException {
        if (value.length() != 1) {
            throw new InvalidAttributeException("Character data-type is restricted to single character values");
        }
        this.value = new Character(value.charAt(0));
    }

    public CharacterAttribute(Character value) {
        this.value = value;
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.CHARACTER;
    }

    @Override
    public Character getValue() {
        return this.value;
    }

    @Override
    public int compareTo(CharacterAttribute other) {
        return this.value.compareTo(other.value);
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.getValue());
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharacterAttribute)) {
            return false;
        }
        CharacterAttribute other = (CharacterAttribute)o;
        return this.value.equals(other.value);
    }

    @Override
    public int internalHashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean add(CharacterAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends CharacterAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<CharacterAttribute> iterator() {
        return new Iterator<CharacterAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public CharacterAttribute next() {
                this.nextNotCalled = false;
                return CharacterAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((CharacterAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((CharacterAttribute)x0);
    }
}

