/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.TimeZone;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DateAttribute
extends AttributeValue<DateAttribute> {
    private static final long MINUTES_PER_HOUR = 60L;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final long MILLIS_PER_HOUR = 3600000L;
    private Calendar value;
    private boolean isTimeZoneExplicit;

    public DateAttribute(Calendar value) {
        this(value, true);
    }

    public DateAttribute(Calendar value, boolean isTimeZoneExplicit) {
        this.value = (Calendar)value.clone();
        this.value.set(10, 0);
        this.value.set(12, 0);
        this.value.set(13, 0);
        this.value.set(14, 0);
        this.isTimeZoneExplicit = isTimeZoneExplicit;
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.DATE;
    }

    public DateAttribute(String value) throws InvalidAttributeException {
        this(value, false);
    }

    public DateAttribute(String value, boolean lenient) throws InvalidAttributeException {
        char digit;
        int i;
        int nextDash;
        boolean yearNegative;
        int idx = 0;
        this.checkLength(idx, 1, value);
        if (value.charAt(idx) == '+' && lenient) {
            ++idx;
        }
        boolean bl = yearNegative = value.charAt(idx) == '-';
        if (yearNegative) {
            ++idx;
        }
        if ((nextDash = value.indexOf(45, idx)) < idx + 4) {
            this.throwInvalidAttributeException();
        }
        if (nextDash > idx + 4 && value.charAt(idx) == '0') {
            this.throwInvalidAttributeException();
        }
        for (i = idx; i < nextDash; ++i) {
            digit = value.charAt(i);
            if (Character.isDigit(digit)) continue;
            this.throwInvalidAttributeException();
        }
        int year = Integer.parseInt(value.substring(idx, nextDash));
        if (yearNegative) {
            year = -1 * year;
        }
        this.checkLength(nextDash, 1, value);
        idx = nextDash + 1;
        nextDash = value.indexOf(45, idx);
        if (nextDash != idx + 2) {
            this.throwInvalidAttributeException();
        }
        for (i = idx; i < nextDash; ++i) {
            digit = value.charAt(i);
            if (Character.isDigit(digit)) continue;
            this.throwInvalidAttributeException();
        }
        int month = Integer.parseInt(value.substring(idx, nextDash));
        if (month < 1 || month > 12) {
            this.throwInvalidAttributeException();
        }
        this.checkLength(nextDash, 3, value);
        idx = nextDash + 1;
        nextDash = idx + 2;
        for (i = idx; i < nextDash; ++i) {
            digit = value.charAt(i);
            if (Character.isDigit(digit)) continue;
            this.throwInvalidAttributeException();
        }
        if (nextDash < value.length() && Character.isDigit(value.charAt(nextDash))) {
            this.throwInvalidAttributeException();
        }
        int day = Integer.parseInt(value.substring(idx, nextDash));
        this.isTimeZoneExplicit = false;
        TimeZone tz = null;
        if (nextDash < value.length()) {
            char next = value.charAt(nextDash);
            switch (next) {
                case 'Z': {
                    tz = TimeZone.getTimeZone("GMT");
                    ++nextDash;
                    break;
                }
                case '+': 
                case '-': {
                    int tzMinute;
                    int tzHour;
                    this.checkLength(nextDash, 6, value);
                    if (!(Character.isDigit(value.charAt(nextDash + 1)) && Character.isDigit(value.charAt(nextDash + 2)) && value.charAt(nextDash + 3) == ':' && Character.isDigit(value.charAt(nextDash + 4)) && Character.isDigit(value.charAt(nextDash + 5)))) {
                        this.throwInvalidAttributeException();
                    }
                    if ((tzHour = Integer.parseInt(value.substring(nextDash + 1, nextDash + 3))) <= 0 || tzHour > 14) {
                        this.throwInvalidAttributeException();
                    }
                    if ((tzMinute = Integer.parseInt(value.substring(nextDash + 4, nextDash + 6))) < 0 || tzMinute > 59 || tzHour == 14 && tzMinute != 0) {
                        this.throwInvalidAttributeException();
                    }
                    tz = TimeZone.getTimeZone(new StringBuffer().append("GMT").append(value.substring(nextDash, nextDash + 6)).toString());
                    nextDash += 6;
                    break;
                }
                default: {
                    this.throwInvalidAttributeException();
                }
            }
            this.isTimeZoneExplicit = true;
            if (nextDash < value.length()) {
                this.throwInvalidAttributeException();
            }
        }
        Calendar cal = tz != null ? Calendar.getInstance(tz) : Calendar.getInstance();
        cal.set(1, year);
        if (cal.getActualMinimum(2) > --month || cal.getActualMaximum(2) < month) {
            this.throwInvalidAttributeException();
        }
        cal.set(2, month);
        if (cal.getActualMinimum(5) > day || cal.getActualMaximum(5) < day) {
            this.throwInvalidAttributeException();
        }
        cal.set(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.value = cal;
    }

    private void checkLength(int idx, int length, String value) throws InvalidAttributeException {
        if (idx + (length - 1) >= value.length()) {
            this.throwInvalidAttributeException();
        }
    }

    private void throwInvalidAttributeException() throws InvalidAttributeException {
        throw new InvalidAttributeException("date value does not conform to: '-'? yyyy '-' mm '-' dd (zzzzzz)?");
    }

    @Override
    public Calendar getValue() {
        return this.value;
    }

    @Override
    public int compareTo(DateAttribute other) {
        long ot;
        long t = this.value.getTimeInMillis();
        return t == (ot = other.value.getTimeInMillis()) ? 0 : (t < ot ? -1 : 1);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        String yearString = String.valueOf(this.value.get(1));
        int ysLength = yearString.length();
        while (ysLength++ < 4) {
            sb.append('0');
        }
        sb.append(yearString);
        sb.append('-');
        String monthString = String.valueOf(this.value.get(2) + 1);
        if (monthString.length() < 2) {
            sb.append('0');
        }
        sb.append(monthString);
        sb.append('-');
        String dayString = String.valueOf(this.value.get(5));
        if (dayString.length() < 2) {
            sb.append('0');
        }
        sb.append(dayString);
        if (this.isTimeZoneExplicit) {
            int offset = this.value.get(15);
            if (offset == 0) {
                sb.append('Z');
            } else {
                if (offset < 0) {
                    sb.append('-');
                    offset = Math.abs(offset);
                } else {
                    sb.append('+');
                }
                int zoneHours = offset / 3600000;
                String zoneHoursStr = String.valueOf(zoneHours);
                if (zoneHoursStr.length() < 2) {
                    sb.append('0');
                }
                sb.append(zoneHoursStr);
                sb.append(':');
                offset = Math.abs(offset);
                offset = (int)((long)offset - (long)zoneHours * 3600000L);
                String zoneMinutesStr = String.valueOf(offset / 60000);
                if (zoneMinutesStr.length() < 2) {
                    sb.append('0');
                }
                sb.append(zoneMinutesStr);
            }
        }
        return sb.toString();
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.toString());
    }

    @Override
    public boolean equals(Object o) {
        long ot;
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateAttribute)) {
            return false;
        }
        DateAttribute other = (DateAttribute)o;
        long t = this.value.getTimeInMillis();
        return t == (ot = other.value.getTimeInMillis());
    }

    @Override
    public int internalHashCode() {
        return this.value.getTime().hashCode();
    }

    @Override
    public boolean add(DateAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends DateAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<DateAttribute> iterator() {
        return new Iterator<DateAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public DateAttribute next() {
                this.nextNotCalled = false;
                return DateAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((DateAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((DateAttribute)x0);
    }
}

