/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DoubleAttribute
extends AttributeValue<DoubleAttribute> {
    private static final Double NAN = new Double(Double.NaN);
    private Double value;

    public DoubleAttribute(double value) {
        if (value == Double.NaN) {
            this.value = NAN;
        }
        this.value = new Double(value);
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.DOUBLE;
    }

    public DoubleAttribute(Double value) {
        if (value == Double.NaN) {
            this.value = NAN;
        }
        this.value = value;
    }

    public DoubleAttribute(String value) throws InvalidAttributeException {
        try {
            this.value = "INF".equals(value) ? new Double(Double.POSITIVE_INFINITY) : ("-INF".equals(value) ? new Double(Double.NEGATIVE_INFINITY) : ("NaN".equals(value) ? NAN : new Double(Double.parseDouble(value))));
        }
        catch (NumberFormatException nfe) {
            throw new InvalidAttributeException(nfe);
        }
    }

    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.toString());
    }

    @Override
    public int compareTo(DoubleAttribute other) {
        return this.value.compareTo(other.value);
    }

    @Override
    public String toString() {
        if (Double.POSITIVE_INFINITY == this.value) {
            return "INF";
        }
        if (Double.NEGATIVE_INFINITY == this.value) {
            return "-INF";
        }
        if (NAN == this.value) {
            return "NaN";
        }
        DecimalFormat df = new DecimalFormat("0.0#################E0");
        return df.format(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DoubleAttribute)) {
            return false;
        }
        DoubleAttribute other = (DoubleAttribute)o;
        return this.value == other.value || this.value != null && this.value.equals(other.value);
    }

    @Override
    public int internalHashCode() {
        return this.value.intValue();
    }

    @Override
    public boolean add(DoubleAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends DoubleAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<DoubleAttribute> iterator() {
        return new Iterator<DoubleAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public DoubleAttribute next() {
                this.nextNotCalled = false;
                return DoubleAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((DoubleAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((DoubleAttribute)x0);
    }
}

