/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import com.bea.common.security.xacml.attr.Bag;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericBag<E extends AttributeValue>
extends Bag<E> {
    private Collection<E> contents;

    protected GenericBag() {
        this(new ArrayList());
    }

    protected GenericBag(Collection<E> contents) {
        this.contents = contents;
    }

    public GenericBag(Type type) {
        this(type, new ArrayList());
    }

    public GenericBag(Type type, Collection<E> contents) {
        super(GenericBag.getBagType(type));
        this.contents = contents;
    }

    public void encodeValue(PrintStream ps) {
        throw new UnsupportedOperationException();
    }

    private static Type getBagType(Type t) {
        return t.isBag() ? t : new Type(t, true);
    }

    @Override
    public boolean isBag() {
        return true;
    }

    public Collection<E> getValue() {
        return this.contents;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericBag)) {
            return false;
        }
        GenericBag other = (GenericBag)o;
        try {
            if (!this.getType().equals(other.getType())) {
                return false;
            }
        }
        catch (URISyntaxException u) {
            return false;
        }
        return CollectionUtil.equals(this.contents, other.contents);
    }

    @Override
    public int internalHashCode() {
        try {
            int result = 23;
            result = HashCodeUtil.hash((int)result, (Object)this.getType());
            result = HashCodeUtil.hash((int)result, this.contents);
            return result;
        }
        catch (URISyntaxException u) {
            return 0;
        }
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.contents.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.contents.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.contents.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.contents.toArray(arg0);
    }

    @Override
    public boolean add(E arg0) {
        return this.contents.add(arg0);
    }

    @Override
    public boolean remove(Object o) {
        return this.contents.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.contents.containsAll(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends E> arg0) {
        return this.contents.addAll(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.contents.removeAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.contents.retainAll(arg0);
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    @Override
    public boolean add(Object x0) {
        return this.add((E)((AttributeValue)x0));
    }
}

