/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.ApiLogger;
import com.bea.common.security.jdkutils.WeaverUtil;
import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import com.bea.common.security.xacml.attr.ByteArrayHolder;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HexBinaryAttribute
extends AttributeValue<HexBinaryAttribute> {
    private byte[] value;

    public HexBinaryAttribute(byte[] value) {
        this.value = value;
    }

    public HexBinaryAttribute(String value) throws InvalidAttributeException {
        int len = value.length();
        if (len % 2 != 0) {
            throw new InvalidAttributeException(ApiLogger.getHexBinaryBadLength());
        }
        int byteCount = len / 2;
        byte[] bytes = new byte[byteCount];
        int charIndex = 0;
        for (int byteIndex = 0; byteIndex < byteCount; ++byteIndex) {
            int hiNibble = this.hexToBinNibble(value.charAt(charIndex++));
            int loNibble = this.hexToBinNibble(value.charAt(charIndex++));
            bytes[byteIndex] = (byte)(hiNibble * 16 + loNibble);
        }
        this.value = bytes;
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.HEX_BINARY;
    }

    private int hexToBinNibble(char c) throws InvalidAttributeException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new InvalidAttributeException(ApiLogger.getInvalidHexDigit());
    }

    @Override
    public ByteArrayHolder getValue() {
        return new ByteArrayHolder(this.value){

            public String toString() {
                byte[] v = this.getData();
                StringBuffer sb = new StringBuffer();
                for (int byteIndex = 0; byteIndex < v.length; ++byteIndex) {
                    byte b = v[byteIndex];
                    sb.append(HexBinaryAttribute.access$000(HexBinaryAttribute.this, b >> 4 & 0xF));
                    sb.append(HexBinaryAttribute.access$000(HexBinaryAttribute.this, b & 0xF));
                }
                return sb.toString();
            }
        };
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.toString());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int byteIndex = 0; byteIndex < this.value.length; ++byteIndex) {
            byte b = this.value[byteIndex];
            sb.append(this.binToHexNibble(b >> 4 & 0xF));
            sb.append(this.binToHexNibble(b & 0xF));
        }
        return sb.toString();
    }

    private char binToHexNibble(int nibble) {
        boolean result = false;
        return nibble < 10 ? (char)(nibble + 48) : (char)(nibble - 10 + 65);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HexBinaryAttribute)) {
            return false;
        }
        HexBinaryAttribute other = (HexBinaryAttribute)o;
        return Arrays.equals(this.value, other.value);
    }

    @Override
    public int internalHashCode() {
        return WeaverUtil.Arrays.hashCode((byte[])this.value);
    }

    @Override
    public int compareTo(HexBinaryAttribute other) {
        int l = this.value.length;
        int lo = other.value.length;
        int i = 0;
        int j = 0;
        while (i < l) {
            if (j < lo) {
                if (this.value[i] != other.value[j]) {
                    return this.value[i] - other.value[j];
                }
            } else {
                return Math.abs(this.value[i]);
            }
            ++i;
            ++j;
        }
        if (j >= lo) {
            return 0;
        }
        return Math.abs(other.value[j]) * -1;
    }

    @Override
    public boolean add(HexBinaryAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends HexBinaryAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<HexBinaryAttribute> iterator() {
        return new Iterator<HexBinaryAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public HexBinaryAttribute next() {
                this.nextNotCalled = false;
                return HexBinaryAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((HexBinaryAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((HexBinaryAttribute)x0);
    }

    static char access$000(HexBinaryAttribute x0, int x1) {
        return x0.binToHexNibble(x1);
    }
}

