/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class IntegerAttribute
extends AttributeValue<IntegerAttribute> {
    private int value;

    public IntegerAttribute(int value) {
        this.value = value;
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.INTEGER;
    }

    public IntegerAttribute(Integer value) {
        this((int)value);
    }

    public IntegerAttribute(String value) throws InvalidAttributeException {
        try {
            this.value = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidAttributeException(nfe);
        }
    }

    public int getIntValue() {
        return this.value;
    }

    @Override
    public Integer getValue() {
        return new Integer(this.value);
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.getIntValue());
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(IntegerAttribute other) {
        return this.value - other.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegerAttribute)) {
            return false;
        }
        IntegerAttribute other = (IntegerAttribute)o;
        return this.value == other.value;
    }

    @Override
    public int internalHashCode() {
        return this.value;
    }

    @Override
    public boolean add(IntegerAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends IntegerAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IntegerAttribute> iterator() {
        return new Iterator<IntegerAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public IntegerAttribute next() {
                this.nextNotCalled = false;
                return IntegerAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((IntegerAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((IntegerAttribute)x0);
    }
}

