/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.ApiLogger;
import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RFC822NameAttribute
extends AttributeValue<RFC822NameAttribute> {
    private String value;
    private String localPart;
    private String domainPart;

    public RFC822NameAttribute(String value) throws InvalidAttributeException {
        this.value = value;
        int idx = value.indexOf(64);
        if (idx <= 0 || idx >= value.length()) {
            throw new InvalidAttributeException(ApiLogger.getInvalidRFC822Name(value));
        }
        this.localPart = value.substring(0, idx);
        this.domainPart = value.substring(idx + 1);
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.RFC822_NAME;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.getValue());
    }

    @Override
    public String toString() {
        return this.value;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getDomainPart() {
        return this.domainPart;
    }

    @Override
    public int compareTo(RFC822NameAttribute other) {
        int comp = this.domainPart.compareToIgnoreCase(other.domainPart);
        if (comp != 0) {
            return comp;
        }
        return this.localPart.compareTo(other.localPart);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RFC822NameAttribute)) {
            return false;
        }
        RFC822NameAttribute other = (RFC822NameAttribute)o;
        return this.compareTo(other) == 0;
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.localPart);
        result = HashCodeUtil.hash((int)result, (Object)this.domainPart.toLowerCase());
        return result;
    }

    @Override
    public boolean add(RFC822NameAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends RFC822NameAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<RFC822NameAttribute> iterator() {
        return new Iterator<RFC822NameAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public RFC822NameAttribute next() {
                this.nextNotCalled = false;
                return RFC822NameAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((RFC822NameAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((RFC822NameAttribute)x0);
    }
}

