/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AnyURIAttribute;
import com.bea.common.security.xacml.attr.AttributeFactory;
import com.bea.common.security.xacml.attr.AttributeValue;
import com.bea.common.security.xacml.attr.Base64BinaryAttribute;
import com.bea.common.security.xacml.attr.BooleanAttribute;
import com.bea.common.security.xacml.attr.CharacterAttribute;
import com.bea.common.security.xacml.attr.DNSAddressAttribute;
import com.bea.common.security.xacml.attr.DateAttribute;
import com.bea.common.security.xacml.attr.DateTimeAttribute;
import com.bea.common.security.xacml.attr.DayTimeDurationAttribute;
import com.bea.common.security.xacml.attr.DecimalAttribute;
import com.bea.common.security.xacml.attr.DoubleAttribute;
import com.bea.common.security.xacml.attr.FloatAttribute;
import com.bea.common.security.xacml.attr.HexBinaryAttribute;
import com.bea.common.security.xacml.attr.IPAddressAttribute;
import com.bea.common.security.xacml.attr.IntegerAttribute;
import com.bea.common.security.xacml.attr.LongAttribute;
import com.bea.common.security.xacml.attr.RFC822NameAttribute;
import com.bea.common.security.xacml.attr.SimpleAttributeFactory;
import com.bea.common.security.xacml.attr.StringAttribute;
import com.bea.common.security.xacml.attr.TimeAttribute;
import com.bea.common.security.xacml.attr.X500NameAttribute;
import com.bea.common.security.xacml.attr.YearMonthDurationAttribute;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardAttributes
implements AttributeFactory {
    private Map<URI, SimpleAttributeFactory> registry = new HashMap<URI, SimpleAttributeFactory>();

    private void register(URI identifier, SimpleAttributeFactory saf) {
        this.registry.put(identifier, saf);
    }

    public StandardAttributes() throws URISyntaxException {
        this.register(Type.ANY_URI.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                try {
                    return new AnyURIAttribute(new URI(attribute));
                }
                catch (java.net.URISyntaxException use) {
                    throw new URISyntaxException(use);
                }
            }
        });
        this.register(Type.BASE64_BINARY.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new Base64BinaryAttribute(attribute);
            }
        });
        this.register(Type.BOOLEAN.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new BooleanAttribute(attribute);
            }
        });
        this.register(Type.DATE.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new DateAttribute(attribute);
            }
        });
        this.register(Type.DATE_TIME.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new DateTimeAttribute(attribute);
            }
        });
        this.register(Type.DAY_TIME_DURATION.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new DayTimeDurationAttribute(attribute);
            }
        });
        this.register(Type.DNS_ADDRESS.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new DNSAddressAttribute(attribute);
            }
        });
        this.register(Type.DOUBLE.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new DoubleAttribute(attribute);
            }
        });
        this.register(Type.HEX_BINARY.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new HexBinaryAttribute(attribute);
            }
        });
        this.register(Type.INTEGER.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new IntegerAttribute(attribute);
            }
        });
        this.register(Type.IP_ADDRESS.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new IPAddressAttribute(attribute);
            }
        });
        this.register(Type.RFC822_NAME.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new RFC822NameAttribute(attribute);
            }
        });
        this.register(Type.STRING.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new StringAttribute(attribute);
            }
        });
        this.register(Type.TIME.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new TimeAttribute(attribute);
            }
        });
        this.register(Type.X500_NAME.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new X500NameAttribute(attribute);
            }
        });
        this.register(Type.YEAR_MONTH_DURATION.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new YearMonthDurationAttribute(attribute);
            }
        });
        this.register(Type.CHARACTER.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new CharacterAttribute(attribute);
            }
        });
        this.register(Type.LONG.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new LongAttribute(attribute);
            }
        });
        this.register(Type.FLOAT.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new FloatAttribute(attribute);
            }
        });
        this.register(Type.DECIMAL.getDataType(), new SimpleAttributeFactory(){

            public AttributeValue createAttribute(String attribute) throws InvalidAttributeException, URISyntaxException {
                return new DecimalAttribute(attribute);
            }
        });
    }

    @Override
    public AttributeValue createAttribute(Node attribute, Iterator<AttributeFactory> otherFactories) throws URISyntaxException, InvalidAttributeException {
        try {
            return this.createAttribute(new URI(attribute.getAttributes().getNamedItem("DataType").getNodeValue()), attribute, otherFactories);
        }
        catch (java.net.URISyntaxException use) {
            throw new URISyntaxException(use);
        }
    }

    @Override
    public AttributeValue createAttribute(URI dataType, Node attribute, Iterator<AttributeFactory> otherFactories) throws URISyntaxException, InvalidAttributeException {
        SimpleAttributeFactory saf = this.registry.get(dataType);
        if (saf != null) {
            Node node = attribute.getFirstChild();
            String value = null;
            if (node == null) {
                value = "";
            } else {
                switch (node.getNodeType()) {
                    case 3: 
                    case 4: 
                    case 8: {
                        value = node.getNodeValue();
                        break;
                    }
                    default: {
                        throw new InvalidAttributeException("AttributeValue did not contain appropriate child element");
                    }
                }
            }
            return saf.createAttribute(value);
        }
        return null;
    }
}

