/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.attr;

import com.bea.common.security.ApiLogger;
import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.utils.Pair;
import com.bea.common.security.xacml.InvalidAttributeException;
import com.bea.common.security.xacml.Type;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeValue;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class X500NameAttribute
extends AttributeValue<X500NameAttribute> {
    private final String value;
    private final List<Pair<String, String>> components;

    public X500NameAttribute(String value) throws InvalidAttributeException {
        this.value = value;
        this.components = new ArrayList<Pair<String, String>>();
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreTokens()) {
            String comp = st.nextToken().trim();
            if (comp == null || comp.length() == 0) {
                throw new InvalidAttributeException(ApiLogger.getIllegalX500Value(value));
            }
            int idx = comp.indexOf(61);
            if (idx <= 0 || idx >= comp.length() - 1) {
                throw new InvalidAttributeException(new StringBuffer().append("Illegal X500 value: ").append(value).toString());
            }
            this.components.add((Pair<String, String>)new Pair((Object)comp.substring(0, idx).toLowerCase(), (Object)comp.substring(idx + 1)));
        }
    }

    @Override
    public Type getType() throws URISyntaxException {
        return Type.X500_NAME;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public List<Pair<String, String>> getComponents() {
        return this.components;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public void encodeValue(PrintStream ps) {
        ps.print(this.getValue());
    }

    @Override
    public int compareTo(X500NameAttribute other) {
        ListIterator<Pair<String, String>> lt = this.components.listIterator(this.components.size());
        ListIterator<Pair<String, String>> lo = other.components.listIterator(other.components.size());
        while (lt.hasPrevious()) {
            if (!lo.hasPrevious()) {
                return 1;
            }
            Pair<String, String> pt = lt.previous();
            Pair<String, String> po = lo.previous();
            int comp = ((String)pt.getLeft()).compareTo((String)po.getLeft());
            if (comp != 0) {
                return comp;
            }
            comp = ((String)pt.getRight()).compareTo((String)po.getRight());
            if (comp == 0) continue;
            return comp;
        }
        return lo.hasPrevious() ? -1 : 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof X500NameAttribute)) {
            return false;
        }
        X500NameAttribute other = (X500NameAttribute)o;
        return this.compareTo(other) == 0;
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.components);
        return result;
    }

    @Override
    public boolean add(X500NameAttribute o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends X500NameAttribute> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<X500NameAttribute> iterator() {
        return new Iterator<X500NameAttribute>(){
            boolean nextNotCalled = true;

            @Override
            public boolean hasNext() {
                return this.nextNotCalled;
            }

            @Override
            public X500NameAttribute next() {
                this.nextNotCalled = false;
                return X500NameAttribute.this;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object next() {
                return this.next();
            }
        };
    }

    @Override
    public Object getValue() {
        return this.getValue();
    }

    @Override
    public int compareTo(Object x0) {
        return this.compareTo((X500NameAttribute)x0);
    }

    @Override
    public boolean add(Object x0) {
        return this.add((X500NameAttribute)x0);
    }
}

