/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.context;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.context.Attribute;
import com.bea.common.security.xacml.context.ContextSchemaObject;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Action
extends ContextSchemaObject {
    private static final long serialVersionUID = -4392654822830210552L;
    private List<Attribute> attributes;

    public Action() {
        this(null);
    }

    public Action(List<Attribute> attributes) {
        this.attributes = attributes != null ? Collections.unmodifiableList(attributes) : null;
    }

    public Action(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        this.attributes = new ArrayList<Attribute>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("Attribute")) continue;
            this.attributes.add(new Attribute(registry, node));
        }
        this.attributes = this.attributes.isEmpty() ? null : Collections.unmodifiableList(this.attributes);
    }

    @Override
    public String getElementName() {
        return "Action";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.attributes != null) {
            for (Attribute a : this.attributes) {
                a.encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Action)) {
            return false;
        }
        Action o = (Action)other;
        return CollectionUtil.equals(this.attributes, o.attributes);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.attributes);
        return result;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }
}

