/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.context;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.attr.Bag;
import com.bea.common.security.xacml.context.AttributeValue;
import com.bea.common.security.xacml.context.ContextSchemaObject;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
extends ContextSchemaObject {
    private static final long serialVersionUID = -1285696818824143651L;
    private URI attributeId;
    private URI dataType;
    private String issuer;
    private List<AttributeValue> avs;

    public Attribute(URI attributeId, URI dataType, List<AttributeValue> avs) {
        this(attributeId, dataType, null, avs);
    }

    public Attribute(URI attributeId, URI dataType, Bag<com.bea.common.security.xacml.attr.AttributeValue> values) {
        this(attributeId, dataType, null, values);
    }

    public Attribute(URI attributeId, URI dataType, String issuer, Bag<com.bea.common.security.xacml.attr.AttributeValue> values) {
        this(attributeId, dataType, issuer, Attribute.convertValues(values));
    }

    private static List<AttributeValue> convertValues(Bag<com.bea.common.security.xacml.attr.AttributeValue> values) {
        ArrayList<AttributeValue> avs = null;
        if (values != null) {
            avs = new ArrayList<AttributeValue>();
            for (com.bea.common.security.xacml.attr.AttributeValue av : values) {
                avs.add(new AttributeValue(av));
            }
        }
        return avs;
    }

    public Attribute(URI attributeId, URI dataType, String issuer, List<AttributeValue> avs) {
        this.attributeId = attributeId;
        this.dataType = dataType;
        this.issuer = issuer;
        this.avs = avs != null ? Collections.unmodifiableList(avs) : null;
    }

    protected Attribute(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        NamedNodeMap attrs = root.getAttributes();
        try {
            this.attributeId = new URI(attrs.getNamedItem("AttributeId").getNodeValue());
            this.dataType = new URI(attrs.getNamedItem("DataType").getNodeValue());
        }
        catch (java.net.URISyntaxException use) {
            throw new URISyntaxException(use);
        }
        Node issuerNode = attrs.getNamedItem("Issuer");
        if (issuerNode != null) {
            this.issuer = issuerNode.getNodeValue();
        }
        NodeList nodes = root.getChildNodes();
        ArrayList<AttributeValue> avs = new ArrayList<AttributeValue>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            com.bea.common.security.xacml.attr.AttributeValue av;
            Node node = nodes.item(i);
            if (!this.getLocalName(node).equals("AttributeValue") || (av = registry.getAttribute(this.dataType, node)) == null) continue;
            avs.add(new AttributeValue(av));
        }
        this.avs = !avs.isEmpty() ? Collections.unmodifiableList(avs) : null;
    }

    @Override
    public String getElementName() {
        return "Attribute";
    }

    @Override
    public void encodeAttributes(PrintStream ps) {
        if (this.attributeId != null) {
            ps.print(" AttributeId=\"");
            ps.print(this.attributeId);
            ps.print("\"");
        }
        if (this.dataType != null) {
            ps.print(" DataType=\"");
            ps.print(this.dataType);
            ps.print("\"");
        }
        if (this.issuer != null) {
            ps.print(" Issuer=\"");
            ps.print(this.issuer);
            ps.print("\"");
        }
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.avs != null) {
            for (AttributeValue av : this.avs) {
                av.encode(nsMap, ps);
            }
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Attribute)) {
            return false;
        }
        Attribute o = (Attribute)other;
        return (this.attributeId == o.attributeId || this.attributeId != null && this.attributeId.equals(o.attributeId)) && (this.dataType == o.dataType || this.dataType != null && this.dataType.equals(o.dataType)) && (this.issuer == o.issuer || this.issuer != null && this.issuer.equals(o.issuer)) && CollectionUtil.equals(this.avs, o.avs);
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.attributeId);
        result = HashCodeUtil.hash((int)result, (Object)this.dataType);
        result = HashCodeUtil.hash((int)result, (Object)this.issuer);
        result = HashCodeUtil.hash((int)result, this.avs);
        return result;
    }

    public URI getAttributeId() {
        return this.attributeId;
    }

    public URI getDataType() {
        return this.dataType;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public List<AttributeValue> getAttributeValues() {
        return this.avs;
    }
}

