/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.context;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.CollectionUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.context.Action;
import com.bea.common.security.xacml.context.ContextSchemaObject;
import com.bea.common.security.xacml.context.Environment;
import com.bea.common.security.xacml.context.Resource;
import com.bea.common.security.xacml.context.Subject;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request
extends ContextSchemaObject {
    private static final long serialVersionUID = 8637822746503172604L;
    private List<Subject> subjects;
    private List<Resource> resources;
    private Action action;
    private Environment environment;

    public Request(List<Subject> subjects, List<Resource> resources, Action action, Environment environment) {
        this.subjects = subjects != null ? Collections.unmodifiableList(subjects) : null;
        this.resources = resources != null ? Collections.unmodifiableList(resources) : null;
        this.action = action;
        this.environment = environment;
    }

    public Request(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        this.subjects = new ArrayList<Subject>();
        this.resources = new ArrayList<Resource>();
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String cname = this.getLocalName(node);
            if (cname.equals("Subject")) {
                this.subjects.add(new Subject(registry, node));
                continue;
            }
            if (cname.equals("Resource")) {
                this.resources.add(new Resource(registry, node));
                continue;
            }
            if (cname.equals("Action")) {
                this.action = new Action(registry, node);
                continue;
            }
            if (!cname.equals("Environment")) continue;
            this.environment = new Environment(registry, node);
        }
        this.subjects = this.subjects.isEmpty() ? null : Collections.unmodifiableList(this.subjects);
        this.resources = this.resources.isEmpty() ? null : Collections.unmodifiableList(this.resources);
    }

    @Override
    public String getElementName() {
        return "Request";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.subjects != null) {
            for (Subject s : this.subjects) {
                s.encode(nsMap, ps);
            }
        }
        if (this.resources != null) {
            for (Resource r : this.resources) {
                r.encode(nsMap, ps);
            }
        }
        if (this.action != null) {
            this.action.encode(nsMap, ps);
        }
        if (this.environment != null) {
            this.environment.encode(nsMap, ps);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Request)) {
            return false;
        }
        Request o = (Request)other;
        return CollectionUtil.equals(this.subjects, o.subjects) && CollectionUtil.equals(this.resources, o.resources) && (this.action == o.action || this.action != null && this.action.equals(o.action)) && (this.environment == o.environment || this.environment != null && this.environment.equals(o.environment));
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.subjects);
        result = HashCodeUtil.hash((int)result, this.resources);
        result = HashCodeUtil.hash((int)result, (Object)this.action);
        result = HashCodeUtil.hash((int)result, (Object)this.environment);
        return result;
    }

    public List<Subject> getSubjects() {
        return this.subjects;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public Action getAction() {
        return this.action;
    }

    public Environment getEnvironment() {
        return this.environment;
    }
}

