/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.context;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.context.ContextSchemaObject;
import java.io.PrintStream;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceContent
extends ContextSchemaObject {
    private static final long serialVersionUID = -3288143616817843257L;
    private NamedNodeMap attributes;
    private NodeList children;

    public ResourceContent(NamedNodeMap attributes, NodeList children) {
        this.attributes = attributes;
        this.children = children;
    }

    public ResourceContent(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        this.attributes = root.getAttributes();
        this.children = root.getChildNodes();
    }

    @Override
    public String getElementName() {
        return "ResourceContent";
    }

    @Override
    public void encodeAttributes(PrintStream ps) {
        if (this.attributes != null) {
            ps.print(this.attributes.toString());
        }
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.children != null) {
            ps.print(this.children.toString());
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResourceContent)) {
            return false;
        }
        ResourceContent o = (ResourceContent)other;
        return (this.attributes == o.attributes || this.attributes != null && this.attributes.equals(o.attributes)) && (this.children == o.children || this.children != null && this.children.equals(o.children));
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.attributes);
        result = HashCodeUtil.hash((int)result, (Object)this.children);
        return result;
    }

    public NamedNodeMap getAttributes() {
        return this.attributes;
    }

    public NodeList getChildren() {
        return this.children;
    }
}

