/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.context;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.context.ContextSchemaObject;
import com.bea.common.security.xacml.context.Status;
import com.bea.common.security.xacml.policy.Obligations;
import java.io.PrintStream;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
extends ContextSchemaObject {
    private static final long serialVersionUID = 4515145048060511003L;
    public static final int PERMIT = 0;
    public static final int DENY = 1;
    public static final int INDETERMINATE = 2;
    public static final int NOT_APPLICABLE = 3;
    private static final String PERMIT_VALUE = "Permit";
    private static final String DENY_VALUE = "Deny";
    private static final String INDETERMINATE_VALUE = "Indeterminate";
    private static final String NOT_APPLICABLE_VALUE = "NotApplicable";
    private int decision;
    private Status status;
    private Obligations obligations;
    private String resourceId;

    public Result(int decision) {
        this(decision, null, null, null);
    }

    public Result(int decision, Status status) {
        this(decision, status, null, null);
    }

    public Result(int decision, Obligations obligations) {
        this(decision, null, obligations, null);
    }

    public Result(int decision, String resourceId) {
        this(decision, null, null, resourceId);
    }

    public Result(int decision, Obligations obligations, String resourceId) {
        this(decision, null, obligations, resourceId);
    }

    public Result(int decision, Status status, String resourceId) {
        this(decision, status, null, resourceId);
    }

    public Result(int decision, Status status, Obligations obligations) {
        this(decision, status, obligations, null);
    }

    public Result(int decision, Status status, Obligations obligations, String resourceId) {
        this.decision = decision;
        this.status = status;
        this.obligations = obligations;
        this.resourceId = resourceId;
    }

    public Result(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        NamedNodeMap attrs = root.getAttributes();
        Node node = attrs.getNamedItem("RuleId");
        if (node != null) {
            this.resourceId = node.getNodeValue();
        }
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String cname = this.getLocalName(child);
            if (cname.equals("Decision")) {
                String d = child.getFirstChild().getNodeValue();
                if (PERMIT_VALUE.equals(d)) {
                    this.decision = 0;
                    continue;
                }
                if (INDETERMINATE_VALUE.equals(d)) {
                    this.decision = 2;
                    continue;
                }
                if (NOT_APPLICABLE_VALUE.equals(d)) {
                    this.decision = 3;
                    continue;
                }
                this.decision = 1;
                continue;
            }
            if (cname.equals("Obligations")) {
                this.obligations = new Obligations(registry, child);
                continue;
            }
            if (!cname.equals("Status")) continue;
            this.status = new Status(registry, child);
        }
    }

    @Override
    public String getElementName() {
        return "Result";
    }

    @Override
    public void encodeAttributes(PrintStream ps) {
        if (this.resourceId != null) {
            ps.print(" ResourceId=\"");
            ps.print(this.resourceId);
            ps.print("\"");
        }
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        ps.print("<Decision>");
        switch (this.decision) {
            case 0: {
                ps.print(PERMIT_VALUE);
                break;
            }
            case 1: {
                ps.print(DENY_VALUE);
                break;
            }
            case 2: {
                ps.print(INDETERMINATE_VALUE);
                break;
            }
            case 3: {
                ps.print(NOT_APPLICABLE_VALUE);
            }
        }
        ps.print("</Decision>");
        if (this.status != null) {
            this.status.encode(nsMap, ps);
        }
        if (this.obligations != null) {
            this.obligations.encode(nsMap, ps);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Result)) {
            return false;
        }
        Result o = (Result)other;
        return this.decision == o.decision && (this.status == o.status || this.status != null && this.status.equals(o.status)) && (this.obligations == o.obligations || this.obligations != null && this.obligations.equals(o.obligations)) && (this.resourceId == o.resourceId || this.resourceId != null && this.resourceId.equals(o.resourceId));
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (int)this.decision);
        result = HashCodeUtil.hash((int)result, (Object)this.status);
        result = HashCodeUtil.hash((int)result, (Object)this.obligations);
        result = HashCodeUtil.hash((int)result, (Object)this.resourceId);
        return result;
    }

    public int getDecision() {
        return this.decision;
    }

    public Status getStatus() {
        return this.status;
    }

    public Obligations getObligations() {
        return this.obligations;
    }

    public String getResourceId() {
        return this.resourceId;
    }
}

