/*
 * Decompiled with CFR 0.152.
 */
package com.bea.common.security.xacml.context;

import com.bea.common.security.utils.HashCodeUtil;
import com.bea.common.security.xacml.DocumentParseException;
import com.bea.common.security.xacml.URISyntaxException;
import com.bea.common.security.xacml.attr.AttributeRegistry;
import com.bea.common.security.xacml.context.ContextSchemaObject;
import com.bea.common.security.xacml.context.StatusCode;
import com.bea.common.security.xacml.context.StatusDetail;
import java.io.PrintStream;
import java.net.URI;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Status
extends ContextSchemaObject {
    private static final long serialVersionUID = 5529201125198511360L;
    private static final String OK_CODE = "urn:oasis:names:tc:xacml:1.0:status:ok";
    private StatusCode code;
    private String message;
    private StatusDetail detail;

    public Status(StatusCode code) {
        this(code, null, null);
    }

    public Status(StatusCode code, String message) {
        this(code, message, null);
    }

    public Status(StatusCode code, StatusDetail detail) {
        this(code, null, detail);
    }

    public Status(StatusCode code, String message, StatusDetail detail) {
        this.code = code;
        this.message = message;
        this.detail = detail;
    }

    public Status(AttributeRegistry registry, Node root) throws URISyntaxException, DocumentParseException {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String cname = this.getLocalName(child);
            if (cname.equals("StatusMessage")) {
                this.message = child.getFirstChild().getNodeValue();
                continue;
            }
            if (cname.equals("StatusCode")) {
                this.code = new StatusCode(registry, child);
                continue;
            }
            if (!cname.equals("StatusDetail")) continue;
            this.detail = new StatusDetail(registry, child);
        }
    }

    @Override
    public String getElementName() {
        return "Status";
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public void encodeChildren(Map<String, String> nsMap, PrintStream ps) {
        if (this.code != null) {
            this.code.encode(nsMap, ps);
        }
        if (this.message != null) {
            ps.print("<StatusMessage>");
            ps.print(this.message);
            ps.print("</StatusMessage>");
        }
        if (this.detail != null) {
            this.detail.encode(nsMap, ps);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Status)) {
            return false;
        }
        Status o = (Status)other;
        return (this.code == o.code || (this.code != null ? this.code.equals(o.code) : this.isOK(o))) && (this.detail == o.detail || this.detail != null && this.detail.equals(o.detail));
    }

    public boolean isOK(Status o) {
        if (o == null || o.code == null) {
            return true;
        }
        URI v = o.code.getValue();
        return v == null || OK_CODE.equals(v.toString());
    }

    @Override
    public int internalHashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, (Object)this.code);
        result = HashCodeUtil.hash((int)result, (Object)this.detail);
        return result;
    }

    public StatusCode getStatusCode() {
        return this.code;
    }

    public String getStatusMessage() {
        return this.message;
    }

    public StatusDetail getStatusDetail() {
        return this.detail;
    }
}

